package csbase.rest.adapter.algorithm.v1;

import csbase.logic.algorithms.parameters.FileParameterMode;
import csbase.logic.algorithms.parameters.FileParameterPipeAcceptance;
import csbase.logic.algorithms.parameters.SimpleParameter;
import ibase.rest.model.algorithm.v1.InputFileParameter;
import ibase.rest.model.algorithm.v1.Parameter;

/**
 * Created by mjulia on 10/06/16.
 */
public class InputFileParameterFactory implements  ParameterFactory {

    public ibase.rest.model.algorithm.v1.Parameter buildParameter(SimpleParameter p) {
        ibase.rest.model.algorithm.v1.InputFileParameter parameter =
                new ibase.rest.model.algorithm.v1.InputFileParameter();
        setCommonAttributes(parameter, p);
        parameter.setType(Parameter.TypeEnum.INPUT_FILE);
        if (csbase.logic.algorithms.parameters.InputFileListParameter.class.isInstance(p)) {
            csbase.logic.algorithms.parameters.InputFileListParameter csbaseParam =
                    csbase.logic.algorithms.parameters.InputFileListParameter.class.cast(p);
            parameter.setMultipleSelection(true);
            parameter.setSort(csbaseParam.mustSort());
            parameter.setUseFilter(csbaseParam.usesFilter());
            setMode(csbaseParam.getMode(), parameter);
        }
        else if (csbase.logic.algorithms.parameters.InputFileParameter.class.isInstance(p)) {
            csbase.logic.algorithms.parameters.InputFileParameter csbaseParam =
                    csbase.logic.algorithms.parameters.InputFileParameter.class.cast(p);
            parameter.setMultipleSelection(false);
            parameter.setSort(false);
            parameter.setUseFilter(csbaseParam.usesFilter());
            parameter.setAllowsPipe(csbaseParam.usesPipe().equals(FileParameterPipeAcceptance.TRUE));
            setMode(csbaseParam.getMode(), parameter);
        }
        return parameter;
    }
    private void setMode (FileParameterMode mode, ibase.rest.model.algorithm.v1.InputFileParameter parameter ) {
        switch (mode) {
            case REGULAR_FILE:
                parameter.setCategory(InputFileParameter.CategoryEnum.REGULAR);
                break;
            case DIRECTORY:
                parameter.setCategory(InputFileParameter.CategoryEnum.FOLDER);
                break;
            case DIRECTORY_AND_REGULAR_FILE:
                parameter.setCategory(InputFileParameter.CategoryEnum.BOTH);
                break;
        }
    }
    public Parameter.TypeEnum getType() {
        return Parameter.TypeEnum.INPUT_FILE;
    }
}