package csbase.rest.adapter.algorithm.v1;

import csbase.logic.algorithms.parameters.SimpleParameter;
import ibase.rest.model.algorithm.v1.Parameter;

/**
 * Created by mjulia on 12/06/16.
 */
public class DoubleParameterFactory implements ParameterFactory {
    public ibase.rest.model.algorithm.v1.Parameter buildParameter(SimpleParameter p) {
        ibase.rest.model.algorithm.v1.DoubleParameter parameter =
                new ibase.rest.model.algorithm.v1.DoubleParameter();
        setCommonAttributes(parameter, p);
        parameter.setType(Parameter.TypeEnum.DOUBLE);
        if (csbase.logic.algorithms.parameters.DoubleParameter.class.isInstance(p)) {
            csbase.logic.algorithms.parameters.DoubleParameter csbaseParam =
                    csbase.logic.algorithms.parameters.DoubleParameter.class.cast(p);
            parameter.setMultipleSelection(false);
            parameter.setMaximum(csbaseParam.getMaximum());
            parameter.setMinimum(csbaseParam.getMinimum());
            parameter.setIsMaximumIncluded(csbaseParam.isMaximumIncluded());
            parameter.setIsMinimumIncluded(csbaseParam.isMinimumIncluded());
        } else if (csbase.logic.algorithms.parameters.DoubleListParameter.class.isInstance(p)) {
            parameter.setMultipleSelection(true);
            csbase.logic.algorithms.parameters.DoubleListParameter csbaseParam =
                    csbase.logic.algorithms.parameters.DoubleListParameter.class.cast(p);
            parameter.setMaximum(csbaseParam.getMaximum());
            parameter.setMinimum(csbaseParam.getMinimum());
            parameter.setIsMaximumIncluded(csbaseParam.isMaximumIncluded());
            parameter.setIsMinimumIncluded(csbaseParam.isMinimumIncluded());
        }
        return parameter;
    }
    public Parameter.TypeEnum getType() {
        return Parameter.TypeEnum.DOUBLE;
    }
}
