package csbase.rest.adapter.execution_node.v1;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;

import csbase.logic.SGASet;
import csbase.logic.sga.filter.SGACriteria;
import csbase.logic.sga.filter.SGACriteriaAnd;
import csbase.logic.sga.filter.SGACriteriaByAvailability;
import csbase.logic.sga.filter.SGACriteriaByMinCPUs;
import csbase.logic.sga.filter.SGACriteriaByMinFreeRAMMem;
import csbase.logic.sga.filter.SGACriteriaByPlatform;
import csbase.logic.sga.filter.SGACriteriaByRequirements;
import csbase.logic.sga.filter.SGACriteriaOr;
import csbase.logic.sga.filter.SGAFilter;
import ibase.common.JsonUtil;

public class FilterByJsonRequirements {
    private static final String PLATFORMS_KEY = "csbase_platforms";
    private static final String CPU_AMMOUNT_KEY = "csbase_cpu";
    private static final String MEMORY_AMMOUNT_KEY = "csbase_memory";

    private Map<String, Object> requirements;

    public FilterByJsonRequirements(String requirements) {
        this.requirements = new HashMap<>();
        if (requirements==null) return;
        JsonObject object = JsonUtil.jsonFromString(requirements);
        this.requirements = JsonUtil.jsonToMap(object);
    }

    public List<SGASet> filter(List<SGASet> servers) {
        SGACriteria platformsCriteria = null;
        SGACriteria availabilityCriteria = null;
        SGACriteria minCPUsCriteria = null;
        SGACriteria minMemCriteria = null;
        SGACriteria aditionalCriteria = null;

        // Filtro pela plataforma -> obrigatrio
        List<JsonString> platformsSet = (List<JsonString>) requirements.get(PLATFORMS_KEY);
        requirements.remove(PLATFORMS_KEY);
        if (platformsSet!=null) {
            List<SGACriteria> criterias = new LinkedList<>();
            for (JsonString platform : platformsSet)
                criterias.add(new SGACriteriaByPlatform(platform.getString()));
            platformsCriteria = new SGACriteriaOr(criterias);
        }

        // Filtro por nmero mnimo de CPUs -> opcional
        JsonNumber minCPU = (JsonNumber)requirements.get(CPU_AMMOUNT_KEY);
        requirements.remove(CPU_AMMOUNT_KEY);
        if (minCPU !=null) {
            minCPUsCriteria = new SGACriteriaByMinCPUs(minCPU.longValue());
        }

        // Filtro por quantidade mnima de memria -> opcional
        JsonNumber minMem = (JsonNumber) requirements.get(MEMORY_AMMOUNT_KEY);
        requirements.remove(MEMORY_AMMOUNT_KEY);
        if (minMem != null) {
            minMemCriteria = new SGACriteriaByMinFreeRAMMem(minMem.longValue());
        }

        // Filtro pela disponibilidade
        availabilityCriteria = new SGACriteriaByAvailability();

        // Filtro pelos requisitos adicionais no obrigatrios -> opcional
        Set<String> aditionalRequirements = new HashSet<>();
        for (String key : requirements.keySet()) {
            JsonValue value = (JsonValue) requirements.get(key);
            JsonValue.ValueType type = value.getValueType();
            switch (type) {
                case TRUE:
                    aditionalRequirements.add(key);
                    break;
                case FALSE:
                    break;
            }
        }
        if (aditionalRequirements!=null && !aditionalRequirements.isEmpty())
            aditionalCriteria = new SGACriteriaByRequirements(aditionalRequirements);

        // Todos os criterios
        List<SGACriteria> criteriasToMeet = new LinkedList<SGACriteria>();
        if (platformsCriteria != null)
            criteriasToMeet.add(platformsCriteria);
        if (availabilityCriteria != null)
            criteriasToMeet.add(availabilityCriteria);
        if (minCPUsCriteria != null)
            criteriasToMeet.add(minCPUsCriteria);
        if (minMemCriteria != null)
            criteriasToMeet.add(minMemCriteria);
        if (aditionalCriteria != null)
            criteriasToMeet.add(aditionalCriteria);

        SGACriteria finalCriteria = new SGACriteriaAnd(criteriasToMeet);
        return new SGAFilter(finalCriteria).filter(servers);
    }
}
