/*
 * Decompiled with CFR 0.152.
 */
package csbase.rest.adapter.job.v1;

import csbase.exception.ParseException;
import csbase.exception.algorithms.ParameterNotFoundException;
import csbase.logic.Priority;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.algorithms.AlgorithmVersionId;
import csbase.logic.algorithms.flows.configurator.FlowAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.BooleanParameter;
import csbase.logic.algorithms.parameters.DoubleListParameter;
import csbase.logic.algorithms.parameters.DoubleParameter;
import csbase.logic.algorithms.parameters.EnumerationListParameter;
import csbase.logic.algorithms.parameters.EnumerationParameter;
import csbase.logic.algorithms.parameters.InputFileListParameter;
import csbase.logic.algorithms.parameters.InputFileParameter;
import csbase.logic.algorithms.parameters.IntegerListParameter;
import csbase.logic.algorithms.parameters.IntegerParameter;
import csbase.logic.algorithms.parameters.OutputFileListParameter;
import csbase.logic.algorithms.parameters.OutputFileParameter;
import csbase.logic.algorithms.parameters.RowValue;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.TableParameter;
import csbase.logic.algorithms.parameters.TextListParameter;
import csbase.logic.algorithms.parameters.TextParameter;
import csbase.logic.algorithms.validation.LocalizedMessage;
import csbase.logic.algorithms.validation.Validation;
import csbase.logic.algorithms.validation.ValidationContext;
import csbase.logic.algorithms.validation.ValidationMode;
import csbase.remote.AlgorithmServiceInterface;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.ProjectServiceInterface;
import ibase.common.ServiceUtil;
import ibase.exception.InternalServiceException;
import ibase.rest.model.job.v1.JobTemplate;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.json.JSONArray;

public class JobTemplateValidator {
    public static final String RESOURCE_BUNDLE = "JobTemplateValidator";
    private static final String ALGORITHM_ID_KEY = "algorithmId";
    private static final String VERSION_ID_KEY = "versionId";
    private static final String PROJECT_ID_KEY = "projectId";
    private static final String ROOT = "root";
    private JobTemplate jobTemplate;
    private AlgorithmConfigurator configurator;
    private AlgorithmVersionId algorithmVersionId;
    private String projectId;
    private String algorithmId;
    private String userId;
    private Locale locale;

    private ResourceBundle getBundle() {
        ResourceBundle bundle = ResourceBundle.getBundle(RESOURCE_BUNDLE, this.locale, this.getClass().getClassLoader());
        return bundle;
    }

    public JobTemplateValidator(String userId, JobTemplate jt, Locale locale) {
        this.userId = userId;
        this.jobTemplate = jt;
        this.locale = locale;
        this.validateRemoteCommand();
        this.validateProject();
        this.validateArgs();
        this.validateJobPriority();
    }

    private boolean validateRemoteCommand() {
        Object remoteCommand = this.jobTemplate.getRemoteCommand();
        if (remoteCommand == null) {
            String message = ServiceUtil.getTranslator((ResourceBundle)this.getBundle()).message("remoteCommand.missing.error", new String[0]);
            throw new InternalServiceException(message);
        }
        if (!LinkedHashMap.class.isInstance(remoteCommand)) {
            String message = ServiceUtil.getTranslator((ResourceBundle)this.getBundle()).message("remoteCommand.invalid.format.error", new String[0]);
            throw new InternalServiceException(message);
        }
        LinkedHashMap remoteCommandMap = (LinkedHashMap)LinkedHashMap.class.cast(remoteCommand);
        this.algorithmId = (String)remoteCommandMap.get(ALGORITHM_ID_KEY);
        if (this.algorithmId == null) {
            String message = ServiceUtil.getTranslator((ResourceBundle)this.getBundle()).message("algorithmId.missing.error", new String[0]);
            throw new InternalServiceException(message);
        }
        String versionId = (String)remoteCommandMap.get(VERSION_ID_KEY);
        if (versionId == null) {
            String message = ServiceUtil.getTranslator((ResourceBundle)this.getBundle()).message("versionId.missing.error", new String[0]);
            throw new InternalServiceException(message);
        }
        this.algorithmVersionId = AlgorithmVersionId.create((String)versionId);
        String projectParam = (String)remoteCommandMap.get(PROJECT_ID_KEY);
        if (projectParam == null) {
            String message = ServiceUtil.getTranslator((ResourceBundle)this.getBundle()).message("projectId.missing.error", new String[0]);
            throw new InternalServiceException(message);
        }
        try {
            this.projectId = ServiceUtil.decodeFromBase64((String)projectParam);
            AlgorithmServiceInterface algorithmService = ClientRemoteLocator.algorithmService;
            this.configurator = algorithmService.createAlgorithmConfigurator(this.algorithmId, this.algorithmVersionId);
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
        return true;
    }

    private boolean validateProject() {
        try {
            ProjectServiceInterface projectService = ClientRemoteLocator.projectService;
            if (projectService.openProject((Object)this.projectId, false) == null) {
                String message = ServiceUtil.getTranslator((ResourceBundle)this.getBundle()).message("projectId.not.found.error", new String[]{this.projectId});
                throw new InternalServiceException(message);
            }
            if (!projectService.userCanWrite((Object)this.projectId, (Object)this.userId)) {
                String message = ServiceUtil.getTranslator((ResourceBundle)this.getBundle()).message("projectId.user.can.not.write", new String[]{this.userId, this.projectId});
                throw new InternalServiceException(message);
            }
            return true;
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
    }

    private void validateArgs() {
        LinkedHashMap argsMap = (LinkedHashMap)LinkedHashMap.class.cast(this.jobTemplate.getArgs());
        argsMap.forEach((k, v) -> this.setParameterValue((String)k, v));
        try {
            ValidationContext context = new ValidationContext(ValidationMode.FULL, (Object)this.projectId, (Object)this.userId);
            Validation result = this.configurator.validate(context);
            if (!result.isWellSucceeded()) {
                String message = ServiceUtil.getTranslator((ResourceBundle)this.getBundle()).message("args.invalid.format", new String[0]);
                List errMsgs = result.getMessage();
                for (LocalizedMessage errMsg : errMsgs) {
                    message = message + ": " + errMsg.toString() + "; ";
                }
                throw new InternalServiceException(message);
            }
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
    }

    private void setParameterValue(String key, Object value) {
        try {
            String type = this.configurator.getParameterType(key);
            if (SimpleAlgorithmConfigurator.class.isInstance(this.configurator)) {
                SimpleAlgorithmConfigurator config = (SimpleAlgorithmConfigurator)SimpleAlgorithmConfigurator.class.cast(this.configurator);
                SimpleParameter simpleParameter = config.getSimpleParameter(key);
                this.setParameterValue(simpleParameter, type, value);
            } else if (FlowAlgorithmConfigurator.class.isInstance(this.configurator)) {
                FlowAlgorithmConfigurator config = (FlowAlgorithmConfigurator)FlowAlgorithmConfigurator.class.cast(this.configurator);
                SimpleParameter simpleParameter = config.getNodeParameter(key);
                this.setParameterValue(simpleParameter, type, value);
            }
        }
        catch (ParameterNotFoundException e) {
            throw new InternalServiceException((Throwable)e);
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
    }

    private void setParameterValue(SimpleParameter<?> simpleParameter, String type, Object value) throws ParseException {
        Boolean useRawParameterValues = this.jobTemplate.getUseRawParameterValues();
        if (useRawParameterValues == Boolean.TRUE) {
            simpleParameter.setValueAsText((String)value);
        } else {
            switch (type) {
                case "LIST_OF_INTEGERS": {
                    IntegerListParameter integerListParameter = (IntegerListParameter)IntegerListParameter.class.cast(simpleParameter);
                    JSONArray list = new JSONArray(value);
                    list.forEach(i -> integerListParameter.addElement((Object)((Integer)i)));
                    break;
                }
                case "INTEGER": {
                    IntegerParameter integerParameter = (IntegerParameter)IntegerParameter.class.cast(simpleParameter);
                    integerParameter.setValue((Object)((Integer)value));
                    break;
                }
                case "LIST_OF_DOUBLES": {
                    DoubleListParameter doubleListParameter = (DoubleListParameter)DoubleListParameter.class.cast(simpleParameter);
                    JSONArray list = new JSONArray(value);
                    list.forEach(i -> doubleListParameter.addElement((Object)((Double)i)));
                    break;
                }
                case "DOUBLE": {
                    DoubleParameter doubleParameter = (DoubleParameter)DoubleParameter.class.cast(simpleParameter);
                    doubleParameter.setValue((Object)Double.parseDouble("" + value));
                    break;
                }
                case "BOOLEAN": {
                    BooleanParameter booleanParameter = (BooleanParameter)BooleanParameter.class.cast(simpleParameter);
                    booleanParameter.setValue((Object)((Boolean)value));
                    break;
                }
                case "LIST_OF_TEXTS": {
                    TextListParameter textListParameter = (TextListParameter)TextListParameter.class.cast(simpleParameter);
                    JSONArray list = new JSONArray(value);
                    list.forEach(i -> textListParameter.addElement((Object)((String)i)));
                    break;
                }
                case "TEXT": {
                    TextParameter textParameter = (TextParameter)TextParameter.class.cast(simpleParameter);
                    textParameter.setValue((Object)((String)value));
                    break;
                }
                case "ENUMERATION_LIST": {
                    EnumerationListParameter enumListParameter = (EnumerationListParameter)EnumerationListParameter.class.cast(simpleParameter);
                    JSONArray list = new JSONArray(value);
                    list.forEach(item -> this.addEnumItem(enumListParameter, (String)item));
                    break;
                }
                case "ENUMERATION": {
                    EnumerationParameter enumParameter = (EnumerationParameter)EnumerationParameter.class.cast(simpleParameter);
                    enumParameter.setValue((Object)enumParameter.getItem((String)value));
                }
                case "INPUT_FILE": {
                    if (InputFileParameter.class.isInstance(simpleParameter)) {
                        InputFileParameter inputFileParameter = (InputFileParameter)InputFileParameter.class.cast(simpleParameter);
                        String filePath = ROOT.equalsIgnoreCase((String)value) ? "." : (String)value;
                        inputFileParameter.setValueAsText(filePath);
                        break;
                    }
                    if (InputFileListParameter.class.isInstance(simpleParameter)) {
                        InputFileListParameter inputFileListParameter = (InputFileListParameter)InputFileListParameter.class.cast(simpleParameter);
                        break;
                    }
                }
                case "OUTPUT_FILE": {
                    if (OutputFileParameter.class.isInstance(simpleParameter)) {
                        OutputFileParameter outputFileParameter = (OutputFileParameter)OutputFileParameter.class.cast(simpleParameter);
                        String filePath = ROOT.equalsIgnoreCase((String)value) ? "." : (String)value;
                        outputFileParameter.setValueAsText(filePath);
                        break;
                    }
                    if (OutputFileListParameter.class.isInstance(simpleParameter)) {
                        OutputFileListParameter outputFileListParameter = (OutputFileListParameter)OutputFileListParameter.class.cast(simpleParameter);
                        break;
                    }
                }
                case "TABLE": {
                    if (!TableParameter.class.isInstance(simpleParameter)) break;
                    TableParameter tableParameter = (TableParameter)TableParameter.class.cast(simpleParameter);
                    ArrayList table = (ArrayList)value;
                    int rowCount = table.size();
                    for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                        ArrayList rowElements = (ArrayList)table.get(rowIndex);
                        tableParameter.addRow(new RowValue(rowElements.toArray()));
                    }
                    break;
                }
                default: {
                    simpleParameter.setValueAsText((String)value);
                }
            }
        }
    }

    private String getFileId(String value) {
        return ROOT.equalsIgnoreCase(value) ? "" : ServiceUtil.decodeFromBase64((String)value);
    }

    private void addEnumItem(EnumerationListParameter enumListParameter, String item) {
        try {
            enumListParameter.addElement((Object)enumListParameter.getItemValueFromText(item));
        }
        catch (ParseException e) {
            throw new InternalServiceException((Throwable)e);
        }
    }

    private void validateJobPriority() {
        if (this.jobTemplate.getPriority() < 0 || this.jobTemplate.getPriority() >= Priority.values().length) {
            String message = ServiceUtil.getTranslator((ResourceBundle)this.getBundle()).message("priority.error", new String[0]);
            throw new InternalServiceException(message);
        }
    }

    public String getAlgorithmId() {
        return this.algorithmId;
    }

    public AlgorithmVersionId getAlgorithmmVersionId() {
        return this.algorithmVersionId;
    }

    public AlgorithmConfigurator getAlgorithmConfigurator() {
        return this.configurator;
    }

    public Object getProjectId() {
        return this.projectId;
    }
}

