package csbase.rest.adapter.user.v1;

import java.io.File;
import java.io.InputStream;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

import csbase.exception.PermissionException;
import csbase.logic.UserInfo;
import csbase.remote.AdministrationServiceInterface;
import csbase.remote.ClientRemoteLocator;
import ibase.exception.InternalServiceException;
import ibase.rest.api.user.v1.adapter.User;
import ibase.rest.api.user.v1.adapter.UserService;

/**
 * Implementao do adaptador CSBase para o servio de usurios.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class CSBaseUserServiceImpl implements UserService {

  /**
   * {@inheritDoc}
   */
  @Override
  public void setLocale(Locale locale) {
    ClientRemoteLocator.administrationService.setLocale(locale);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public List<User> getAllUsers() {
    AdministrationServiceInterface service =
      ClientRemoteLocator.administrationService;
    List<csbase.logic.User> users;
    try {
      users = service.getAllUsers();
      List<User> usersToReturn = new ArrayList<User>();
      users.forEach(u -> usersToReturn.add(new CSBaseUser(u)));
      return usersToReturn;
    }
    catch (Throwable e) {
      throw new InternalServiceException(e);
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public File getUserPhotoFile(String userId) {
    try {
      AdministrationServiceInterface service =
        ClientRemoteLocator.administrationService;
      return service.getPhotoFile(userId);
    }
    catch (Throwable e) {
      throw new InternalServiceException(e);
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void setUserPhoto(String userId, InputStream photo, String fileName) {
    try {
      AdministrationServiceInterface service =
        ClientRemoteLocator.administrationService;
      service.setPhotoFile(userId, photo, fileName);
    }
    catch (PermissionException e) {
      throw new ibase.exception.PermissionException();
    }
    catch (Throwable e) {
      throw new InternalServiceException(e);
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public User getUser(String userId) {
    try {
      AdministrationServiceInterface service =
        ClientRemoteLocator.administrationService;
      csbase.logic.User user = service.getUser(userId);
      if (user == null) {
        return null;
      }
      return new CSBaseUser(service.getUser(userId));
    }
    catch (Throwable e) {
      throw new InternalServiceException(e);
    }
  }

  @Override
  public void setUserProfile (String userId, String name, List<String> emails) {
    try {
      AdministrationServiceInterface service =
              ClientRemoteLocator.administrationService;
      csbase.logic.User user = service.getUser(userId);
      UserInfo userInfo = new UserInfo(user.getUserInfo().getAttributes());
      if (name==null) name = user.getName();
      String[] userLogicEmails = user.getEmails();
      if (emails != null && emails.size() > 0) {
        List<String> filteredEmails = emails.stream().filter(email -> !email.isEmpty()).collect(Collectors.toList());
        if (filteredEmails.size() > 0) {
          userLogicEmails = filteredEmails.toArray(new String[filteredEmails.size()]);
        }
      }
      userInfo.setAttribute(csbase.logic.User.NAME, name);
      userInfo.setAttribute(csbase.logic.User.EMAILS, userLogicEmails);
      userInfo.setAttribute(csbase.logic.User.PHOTO_LINK, user.getAttribute(csbase.logic.User.PHOTO_LINK));
      userInfo.setAttribute(csbase.logic.User.LAST_UPDATE, user.getAttribute(csbase.logic.User.LAST_UPDATE));
      userInfo.setAttribute(csbase.logic.User.LAST_PWD_UPDATE, user.getAttribute(csbase.logic.User.LAST_PWD_UPDATE));
      service.modifyUser(userId, userInfo);
    }
    catch (PermissionException e) {
      throw new ibase.exception.PermissionException(e.getMessage());
    }
    catch (Throwable e) {
      throw new InternalServiceException(e);
    }
  }

}
