package csbase.server.services.opendreamsservice.opendreams.v1_04;

import tecgraf.openbus.DRMAA.AlreadyActiveSessionException;
import tecgraf.openbus.DRMAA.AuthorizationException;
import tecgraf.openbus.DRMAA.DefaultContactStringException;
import tecgraf.openbus.DRMAA.DeniedByDrmException;
import tecgraf.openbus.DRMAA.DrmCommunicationException;
import tecgraf.openbus.DRMAA.DrmsExitException;
import tecgraf.openbus.DRMAA.DrmsInitException;
import tecgraf.openbus.DRMAA.ExitTimeoutException;
import tecgraf.openbus.DRMAA.HoldInconsistentStateException;
import tecgraf.openbus.DRMAA.InternalException;
import tecgraf.openbus.DRMAA.InvalidArgumentException;
import tecgraf.openbus.DRMAA.InvalidContactStringException;
import tecgraf.openbus.DRMAA.InvalidJobException;
import tecgraf.openbus.DRMAA.InvalidJobTemplateException;
import tecgraf.openbus.DRMAA.JobControlAction;
import tecgraf.openbus.DRMAA.JobInfo;
import tecgraf.openbus.DRMAA.JobState;
import tecgraf.openbus.DRMAA.JobTemplate;
import tecgraf.openbus.DRMAA.NoActiveSessionException;
import tecgraf.openbus.DRMAA.NoDefaultContactStringSelectedException;
import tecgraf.openbus.DRMAA.OutOfMemoryException;
import tecgraf.openbus.DRMAA.ReleaseInconsistentStateException;
import tecgraf.openbus.DRMAA.ResumeInconsistentStateException;
import tecgraf.openbus.DRMAA.SessionPOA;
import tecgraf.openbus.DRMAA.SuspendInconsistentStateException;
import tecgraf.openbus.DRMAA.TryLaterException;
import tecgraf.openbus.DRMAA.Version;

/**
 * Implementa a idl <code>Session</code> do DRMAA.
 * 
 * @author Tecgraf PUC-Rio
 * 
 */
public abstract class Session extends SessionPOA {

  @Override
  public abstract JobInfo _wait(String jobName, long timeout)
    throws OutOfMemoryException, AuthorizationException,
    NoActiveSessionException, ExitTimeoutException, InvalidArgumentException,
    InternalException, InvalidJobException, DrmCommunicationException;

  @Override
  public abstract String contact();

  @Override
  public void control(String jobName, JobControlAction operation)
    throws InvalidArgumentException, SuspendInconsistentStateException,
    ReleaseInconsistentStateException, InternalException,
    AuthorizationException, DrmCommunicationException,
    HoldInconsistentStateException, InvalidJobException,
    NoActiveSessionException, OutOfMemoryException,
    ResumeInconsistentStateException {
    throw new InternalException("Operao no implementada");
  }

  @Override
  public abstract JobTemplate createJobTemplate() throws OutOfMemoryException,
    AuthorizationException, NoActiveSessionException, InternalException,
    DrmCommunicationException;

  @Override
  public abstract void deleteJobTemplate(JobTemplate jobTemplate)
    throws OutOfMemoryException, InvalidJobTemplateException,
    AuthorizationException, NoActiveSessionException, InvalidArgumentException,
    InternalException, DrmCommunicationException;

  @Override
  public abstract String drmaaImplementation();

  @Override
  public abstract String drmsInfo();

  @Override
  public abstract void exit() throws OutOfMemoryException, DrmsExitException,
    AuthorizationException, NoActiveSessionException, InternalException,
    DrmCommunicationException;

  @Override
  public abstract void init(String contactString)
    throws DefaultContactStringException,
    NoDefaultContactStringSelectedException, InvalidArgumentException,
    AlreadyActiveSessionException, InternalException, DrmsInitException,
    AuthorizationException, DrmCommunicationException,
    InvalidContactStringException, OutOfMemoryException;

  @Override
  public abstract JobState jobStatus(String jobName)
    throws OutOfMemoryException, AuthorizationException,
    NoActiveSessionException, InvalidArgumentException, InternalException,
    InvalidJobException, DrmCommunicationException;

  @Override
  public String[] runBulkJobs(JobTemplate jobTemplate, int arg1, int arg2,
    int arg3) throws InvalidArgumentException, InternalException,
    AuthorizationException, DrmCommunicationException, DeniedByDrmException,
    InvalidJobTemplateException, NoActiveSessionException, TryLaterException,
    OutOfMemoryException {
    throw new InternalException("Operao no implementada");
  }

  @Override
  public abstract String runJob(JobTemplate jobTemplate)
    throws InvalidArgumentException, InternalException, AuthorizationException,
    DrmCommunicationException, DeniedByDrmException,
    InvalidJobTemplateException, NoActiveSessionException, TryLaterException,
    OutOfMemoryException;

  @Override
  public void synchronize(String[] jobList, long timeout, boolean dispose)
    throws OutOfMemoryException, AuthorizationException,
    NoActiveSessionException, ExitTimeoutException, InvalidArgumentException,
    InternalException, InvalidJobException, DrmCommunicationException {
    throw new InternalException("Operao no implementada");
  }

  @Override
  public abstract Version version();

}
