package csbase.server.services.schedulerservice;

import java.io.Serializable;
import java.util.Comparator;

import csbase.logic.CapacityType;
import csbase.logic.SGAInfo;
import csbase.logic.SGASet;

/**
 * Comparador dos SGAs pela carga de CPU e a sua capacidade.
 */
public class SGASetCPUCapacityComparator implements Comparator<SGASet>,
  Serializable {

  /**
   * Compara as capacidades atuais de processamento de dois SGAs.
   * 
   * @param o1
   * @param o2
   * @return -1 quando a capacidade atual de processamento do SGA1 for maior que
   *         a capacidade do SGA2. 0 quando a capacidade atual de processamento
   *         do SGA1 for igual a capacidade do SGA2. 1 quando a capacidade atual
   *         de processamento do SGA1 for menor que a capacidade do SGA2.
   */
  public int compare(SGASet o1, SGASet o2) {
    long cpu1 = o1.getCapacity(CapacityType.CPU);
    long cpu2 = o2.getCapacity(CapacityType.CPU);
    if (cpu1 == SGAInfo.NO_CAPACITY)
      cpu1 = 1;
    if (cpu2 == SGAInfo.NO_CAPACITY)
      cpu2 = 1;
    if ((1 / (o1.getCPULoad1() + 1)) * cpu1 > (1 / (o2.getCPULoad1() + 1))
      * cpu2)
      return -1;
    if ((1 / (o1.getCPULoad1() + 1)) * cpu1 < (1 / (o2.getCPULoad1() + 1))
      * cpu2)
      return 1;
    return 0;
  }

}
