package csbase.server.services.administrationservice;

import java.util.Properties;

/**
 * Fbrica de DAOs (Data Access Objects) para o servio de administrao.
 * Responsvel pela criao dos objetos de acesso a dados de usurios, grupos,
 * perfis, permisses e paltaforma.
 * 
 * @author Jorge Alexandre
 * 
 */
public interface AdministrationDAOFactory {

  /**
   * Cria um objeto de acesso a dados (DAO) de usurios .
   * 
   * @return referncia para o objeto de acesso a dados de usurios.
   */
  UserDAO createUserDAO();

  /**
   * Cria um objeto de acesso a dados (DAO) de grupos de usurios.
   * 
   * @return referncia para o objeto de acesso a dados de grupos de usurios.
   */
  UserGroupDAO createUserGroupDAO();

  /**
   * Cria um objeto de acesso a dados (DAO) de perfis de usurios.
   * 
   * @return referncia para o objeto de acesso a dados de perfis de usurios.
   */
  RoleDAO createRoleDAO();

  /**
   * Cria um objeto de acesso a dados (DAO) de permisses de usurios.
   * 
   * @return referncia para o objeto de acesso a dados de permisses de
   *         usurios.
   */
  PermissionDAO createPermissionDAO();

  /**
   * Cria um objeto de acesso a dados (DAO) de plataforma.
   * 
   * @return referncia para o objeto de acesso a dados de plataforma.
   */
  PlatformDAO createPlatformDAO();

}
