/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.algorithmservice;

import csbase.server.services.algorithmservice.AlgorithmService;
import csbase.server.services.httpservice.UploadResult;
import java.util.Observable;
import java.util.Observer;

class AlgorithmObserver
implements Observer {
    static final int UPLOAD_CONFIG = 1;
    static final int UPLOAD_EXEC = 2;
    static final int UPLOAD_HTML = 3;
    private Object algoId;
    private Object versionId;
    private String platform;
    private int type;
    private Object userId;

    public AlgorithmObserver(Object algoId, Object versionId, int type, Object userId) {
        this(algoId, versionId, null, userId);
        this.type = type;
    }

    public AlgorithmObserver(Object algoId, Object versionId, String platform, Object userId) {
        this.algoId = algoId;
        this.versionId = versionId;
        this.platform = platform;
        this.userId = userId;
        this.type = 2;
    }

    @Override
    public void update(Observable o, Object arg) {
        AlgorithmService service = AlgorithmService.getInstance();
        UploadResult result = (UploadResult)arg;
        if (this.type == 1) {
            service.updateConfigurator(this.algoId, this.versionId, result.getFilePath(), this.userId);
        } else if (this.type == 2) {
            service.updateExecutable(this.algoId, this.versionId, this.platform, result.getFilePath(), this.userId);
        } else if (this.type == 3) {
            service.updateDoc(this.algoId, this.versionId, result.getFilePath(), this.userId);
        }
    }
}

