package csbase.server.services.schedulerservice;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

import csbase.logic.CommandInfo;

/**
 * Classe interna usada para serializar os dados.
 */
class PriorityQueueVO implements Serializable 
{
    /** Filas de prioridade */
    public List<List<CommandInfo>> queues;
    /** ndice para localizao rpida do comando */
    public Map<Object,CommandInfo> commandIndex;
    /** ndice para localizao rpida da fila */
    public Map<Object,List<CommandInfo>> queueIndex;
    /**
     * Indica que a fila est bloqueada, ou seja, todos os comandos permanecem
     * na fila at que ela seja desbloqueada
     **/
    public boolean blocked;
}
