package csbase.server.services.sgaservice;

import csbase.exception.CSBaseException;

/**
 * Representa uma falha durante um procedimento de submisso de um comando para
 * o SGA selecionado pelo escalonador. Esse erro pode ocorrer se escalonamento
 * do comando e a sua submisso, o SGA selecionado no estiver mais registrado
 * ou tiver sido desabilitado.
 * 
 * @author Tecgraf
 */
public class SGANotAvailableException extends CSBaseException {
  /**
   * Constri uma exceo sem descrio nem causa associadas.
   */
  public SGANotAvailableException() {
    super();
  }

  /**
   * Constri uma exceo contendo a descrio do erro correspondente.
   * 
   * @param message a descrio do erro
   */
  public SGANotAvailableException(String message) {
    super(message);
  }

  /**
   * Constri uma exceo contendo a causa/exceo original.
   * 
   * @param exception a exceo original
   */
  public SGANotAvailableException(Throwable exception) {
    super(exception);
  }

  /**
   * Constri uma exceo contendo a descrio do erro e a causa/exceo
   * original.
   * 
   * @param message a descrio do erro
   * @param exception a exceo original
   */
  public SGANotAvailableException(String message, Throwable exception) {
    super(message, exception);
  }
}
