package csbase.server.services.ftcservice;

import java.nio.channels.FileChannel;

import csbase.server.services.repositoryservice.IRepositoryFile;

/**
 * Representao padro para um fornecedor de arquivo. Funciona para arquivos do
 * file system local que no usem nenhum mecanismo de lock.
 *
 * @author Tecgraf
 */
public class FTCRequesterImpl implements FTCRequester {

  /**
   * {@inheritDoc}
   */
  @Override
  public FileChannel createFileChannel(IRepositoryFile file, boolean readOnly)
    throws Exception {
    return file.getFileChannel(readOnly ? "r" : "rw");
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean isLocked(IRepositoryFile file) {
    return false;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void fileChannelClosed(IRepositoryFile file) throws Exception {
    file.close();
  }
}