/**
 * $Id$
 */
package csbase.server.services.openbusservice;

import tecgraf.openbus.Connection;
import tecgraf.openbus.core.v2_0.services.access_control.LoginInfo;

/**
 * Tarefa para a atividades que devem ser feitas aps um relogin. Por exemplo: a
 * re-publicao de ofertas, a re-incrio de observadores.
 * 
 * @author Tecgraf
 */
public class ReloginTask implements Runnable {
  /**
   * Lock.
   */
  private Object lock = new Object();
  /**
   * Flag de notificao.
   */
  private boolean notification = false;
  /**
   * ltimo identificador de login usado para fazer as atividades.
   */
  private String lastLogin = null;
  /**
   * Conexo com o barramento.
   */
  private Connection connection;
  /**
   * O alocador associado a esta tesk.
   */
  private ReloginAllocator allocator;

  /**
   * Construtor.
   * 
   * @param conn a conexo com o barramento.
   * @param alloc o alocador que ser chamados para realizar as atividades aps
   *        o re-login.
   */
  public ReloginTask(Connection conn, ReloginAllocator alloc) {
    connection = conn;
    allocator = alloc;
    Thread thread = new Thread(this);
    thread.setDaemon(true);
    thread.start();
  }

  /**
   * Informa a task para esperar a notivicao de re-login.
   */
  private void waitRelogin() {
    synchronized (lock) {
      while (!notification) {
        try {
          lock.wait();
        }
        catch (InterruptedException e) {
        }
      }
      notification = false;
    }
  }

  /**
   * Informa a task sobre o evento de re-login.
   */
  public void notifyRelogin() {
    synchronized (lock) {
      notification = true;
      lock.notifyAll();
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void run() {
    while (true) {
      waitRelogin();
      LoginInfo login = connection.login();
      if ((login != null) && (!login.id.equals(lastLogin))) {
        for (int i = 1; i < Integer.MAX_VALUE; ++i) {
          try {
            lastLogin = allocator.reallocate(login);
            break;
          }
          catch (Exception e) {
            //TODO Registrar no arquivo de log
            System.err.println("reallocation failure: " + e);
            if (connection.login() == null) {
              break;
            }
            try {
              Thread.sleep(i * 1000);
            }
            catch (InterruptedException ie) {
            }
          }
        }
      }
    }
  }
}
