/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.opendreamsservice.opendreams.v1_04;

import csbase.server.Server;
import csbase.server.services.openbusservice.OpenBusService;
import csbase.server.services.opendreamsservice.opendreams.v1_04.SessionManager;
import org.omg.CORBA.Object;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;
import tecgraf.openbus.DRMAA.AuthorizationException;
import tecgraf.openbus.DRMAA.InternalException;
import tecgraf.openbus.DRMAA.Session;
import tecgraf.openbus.DRMAA.SessionHelper;
import tecgraf.openbus.opendreams.IOpenDreamsPOA;

public class OpenDreams
extends IOpenDreamsPOA {
    private Session session;
    private SessionManager sessionManagement = new SessionManager();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session getSession(String projectName) throws AuthorizationException, InternalException {
        try {
            Object obj;
            String currentUser = OpenBusService.getInstance().initCSBaseAccess();
            try {
                POA poa = OpenBusService.getInstance().getRootPOA();
                obj = poa.servant_to_reference((Servant)this.sessionManagement.getSession(currentUser, projectName));
            }
            catch (Throwable e) {
                String msg = "Erro na recupera\u00e7\u00e3o da sess\u00e3o do usu\u00e1rio " + currentUser + " para o projeto " + projectName;
                Server.logSevereMessage(msg, e);
                throw new InternalException(OpenDreams.formatMessage(e, msg));
            }
            this.session = SessionHelper.narrow((Object)obj);
        }
        finally {
            OpenBusService.getInstance().finishCSBaseAccess();
        }
        return this.session;
    }

    public static String formatMessage(Throwable e, String msg) {
        StringBuffer message = new StringBuffer(msg);
        message.append(": " + e.getMessage());
        message.append("\nCaused by:\n");
        StackTraceElement[] stackTrace = e.getStackTrace();
        for (int i = 0; i < stackTrace.length; ++i) {
            message.append(stackTrace[i].toString() + "\n");
        }
        return message.toString();
    }
}

