/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.repositoryservice;

import csbase.exception.ServiceFailureException;
import csbase.server.Server;
import csbase.server.ServerException;
import csbase.server.Service;
import csbase.server.services.repositoryservice.IRepository;
import csbase.server.services.repositoryservice.IRepositoryFile;
import csbase.server.services.repositoryservice.LocalRepository;
import csbase.server.services.repositoryservice.LocalTempFile;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import tecgraf.javautils.core.io.FileUtils;

public class RepositoryService
extends Service {
    public static final String SERVICE_NAME = "RepositoryService";
    private Map<String, IRepository> repositories = new HashMap<String, IRepository>();

    protected RepositoryService() throws ServerException {
        super(SERVICE_NAME);
    }

    public static RepositoryService getInstance() {
        return (RepositoryService)RepositoryService.getInstance(SERVICE_NAME);
    }

    public synchronized void registerLocalRepository(String uri) {
        this.registerLocalRepository(uri, false);
    }

    public synchronized void registerLocalRepository(String uri, boolean dirMustExist) {
        if (this.containRepository(uri)) {
            String f = "Reposit\u00f3rio j\u00e1 cadastrado: %s";
            throw new IllegalArgumentException(String.format(f, uri));
        }
        File file = new File(uri);
        if (!file.exists()) {
            if (dirMustExist) {
                String f = "N\u00e3o foi poss\u00edvel registrar o reposit\u00f3rio: diret\u00f3rio %s n\u00e3o existe.";
                throw new IllegalArgumentException(String.format(f, uri));
            }
            if (!file.mkdir()) {
                String f = "N\u00e3o foi poss\u00edvel criar o reposit\u00f3rio: %s";
                throw new IllegalArgumentException(String.format(f, uri));
            }
        } else if (!file.isDirectory()) {
            String f = "N\u00e3o foi poss\u00edvel registrar o reposit\u00f3rio: %s n\u00e3o \u00e9 diret\u00f3rio.";
            throw new IllegalArgumentException(String.format(f, uri));
        }
        this.repositories.put(uri, new LocalRepository(uri));
    }

    public synchronized void unregisterLocalRepository(String uri, boolean removeRepository) {
        if (this.containRepository(uri)) {
            if (removeRepository) {
                this.removeLocalRepository(uri);
            }
            this.repositories.remove(uri);
        }
    }

    public synchronized void deleteLocalRepository(String uri) {
        this.unregisterLocalRepository(uri, true);
    }

    public boolean containRepository(String uri) {
        return this.repositories.get(uri) != null;
    }

    public IRepository getRepository(String uri) {
        return this.repositories.get(uri);
    }

    public IRepositoryFile createLocalTempFile(File file) {
        return new LocalTempFile(file);
    }

    public static void createService() throws ServerException {
        new RepositoryService();
    }

    @Override
    protected void initService() throws ServerException {
    }

    @Override
    protected void shutdownService() throws ServerException {
    }

    protected boolean has2Update(Object arg, Object event) {
        return false;
    }

    private void removeLocalRepository(String uri) {
        File file = new File(uri);
        if (file.exists()) {
            if (!FileUtils.delete((File)file)) {
                String errMsg = "N\u00e3o foi poss\u00edvel apagar o reposit\u00f3rio: " + file.getAbsolutePath();
                throw new ServiceFailureException(errMsg);
            }
        } else {
            String errMsg = "RepositoryService:unregisterLocalRepository: " + uri + " n\u00e3o foi poss\u00edvel apagar o reposit\u00f3rio " + file.getAbsolutePath();
            Server.logWarningMessage(errMsg);
        }
    }
}

