/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.ftcservice;

import csbase.remote.FTCServiceInterface;
import csbase.server.Server;
import csbase.server.ServerException;
import csbase.server.Service;
import csbase.server.services.ftcservice.FTCController;
import csbase.server.services.ftcservice.FTCRequester;
import csbase.server.services.ftcservice.FTCRequesterImpl;
import csbase.server.services.repositoryservice.IRepositoryFile;
import csbase.server.services.repositoryservice.RepositoryService;
import java.io.File;
import tecgraf.ftc.common.logic.RemoteFileChannelInfo;
import tecgraf.ftc.server.FileServerConfig;

public class FTCService
extends Service
implements FTCServiceInterface {
    private FTCController controller = null;

    public FTCService() throws ServerException {
        super("FTCService");
    }

    @Override
    public void initService() throws ServerException {
        try {
            this.configController();
            this.controller.start();
        }
        catch (Exception e) {
            throw new ServerException(e);
        }
    }

    private void configController() throws ServerException {
        this.controller = new FTCController(this);
        FileServerConfig config = this.controller.getConfig();
        config.setAcceptMaxPossible(this.getBooleanProperty("acceptMaxClients"));
        config.setClientBufferSize(this.getIntProperty("clientBufferSize"));
        config.setClientTimeout(this.getLongProperty("clientTimeout"));
        if (this.isPropertyNull("hostAddr")) {
            config.setHostName(Server.getInstance().getHostAddr());
        } else {
            config.setHostName(this.getStringProperty("hostAddr"));
        }
        config.setMaxClients(this.getIntProperty("maxClients"));
        config.setPort(this.getIntProperty("port"));
        config.setSelectTimeout(this.getLongProperty("selectTimeout"));
        config.setTestMode(this.getBooleanProperty("testMode"));
        this.controller.setRemoteFileChannelInfoTimeout(this.getLongProperty("remoteFileChannelInfoTimeout"));
    }

    @Override
    public void shutdownService() throws ServerException {
        if (this.controller != null) {
            this.controller.stop();
        }
    }

    protected boolean has2Update(Object arg, Object event) {
        return false;
    }

    public static void createService() throws ServerException {
        new FTCService();
    }

    public static FTCService getInstance() {
        return (FTCService)FTCService.getInstance("FTCService");
    }

    @Deprecated
    public RemoteFileChannelInfo createFileChannelInfo(File file, boolean readOnly) throws Exception {
        RepositoryService rs = RepositoryService.getInstance();
        IRepositoryFile repositoryFile = rs.createLocalTempFile(file);
        return this.controller.createFileChannelInfo(new FTCRequesterImpl(), repositoryFile, readOnly);
    }

    @Deprecated
    public RemoteFileChannelInfo createFileChannelInfo(FTCRequester requester, File file, boolean readOnly) throws Exception {
        RepositoryService rs = RepositoryService.getInstance();
        IRepositoryFile repositoryFile = rs.createLocalTempFile(file);
        return this.controller.createFileChannelInfo(requester, repositoryFile, readOnly);
    }

    public RemoteFileChannelInfo createFileChannelInfo(IRepositoryFile file, boolean readOnly) throws Exception {
        return this.controller.createFileChannelInfo(new FTCRequesterImpl(), file, readOnly);
    }

    public RemoteFileChannelInfo createFileChannelInfo(FTCRequester requester, IRepositoryFile file, boolean readOnly) throws Exception {
        return this.controller.createFileChannelInfo(requester, file, readOnly);
    }
}

