/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.restservice;

import csbase.server.services.restservice.RestService;
import ibase.common.RestErrorMessage;
import ibase.common.ServiceAdapter;
import ibase.rest.api.authentication.v1.adapter.AuthenticationService;
import ibase.rest.api.authentication.v1.adapter.ParseException;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.glassfish.hk2.api.ServiceLocator;

@Priority(value=1000)
public class CSBaseRequestFilter
implements ContainerRequestFilter {
    @Context
    private ServiceLocator serviceLocator;
    @Context
    private UriInfo uriInfo;
    public static String LOCALE_PARAM = "locale";
    private static final Logger logger = Logger.getLogger("CSBaseRequestFilter");

    public void filter(ContainerRequestContext requestContext) throws IOException {
        long now = System.currentTimeMillis();
        ServiceAdapter.setServiceLocator((ServiceLocator)this.serviceLocator);
        ServiceAdapter.setURI((String)RestService.getInstance().getExternalURL());
        ServiceAdapter.addProperty((String)"ftp.SSL.enabled", (String)RestService.getInstance().getStringProperty("ftp.SSL.enabled"));
        ServiceAdapter.addProperty((String)"ftp.SSL.private", (String)RestService.getInstance().getStringProperty("ftp.SSL.private"));
        ServiceAdapter.addProperty((String)"ftp.SSL.auth", (String)RestService.getInstance().getStringProperty("ftp.SSL.auth"));
        ServiceAdapter.addProperty((String)"ftp.passive", (String)RestService.getInstance().getStringProperty("ftp.passive"));
        ServiceAdapter.addProperty((String)"ftp.host", (String)RestService.getInstance().getStringProperty("ftp.host"));
        ServiceAdapter.addProperty((String)"ftp.port", (String)RestService.getInstance().getStringProperty("ftp.port"));
        ServiceAdapter.addProperty((String)"ftp.user", (String)RestService.getInstance().getStringProperty("ftp.user"));
        ServiceAdapter.addProperty((String)"ftp.password", (String)RestService.getInstance().getStringProperty("ftp.password"));
        if (!(requestContext.getUriInfo().getPath().startsWith("authentication") || requestContext.getUriInfo().getPath().equals("swagger.yaml") || requestContext.getUriInfo().getPath().equals("swagger.json") || requestContext.getUriInfo().getPath().startsWith("links/avatar") || requestContext.getUriInfo().getPath().startsWith("links/download") || requestContext.getUriInfo().getPath().startsWith("links/download_multiple") || requestContext.getUriInfo().getPath().startsWith("algorithms/public"))) {
            try {
                AuthenticationService authenticationService = (AuthenticationService)ServiceAdapter.getInstance(AuthenticationService.class, (String)Locale.getDefault().toString());
                String authorizationHeader = requestContext.getHeaderString("Authorization");
                ServiceAdapter.setAuthorizationHeader((String)authorizationHeader);
                String userId = null;
                boolean valid = true;
                if (authorizationHeader == null || !authorizationHeader.startsWith("Bearer ")) {
                    valid = false;
                    List parameters = (List)requestContext.getUriInfo().getQueryParameters().get((Object)"token");
                    if (parameters != null && parameters.size() > 0 && parameters.get(0) != null) {
                        HashMap tokenParams = new HashMap();
                        userId = authenticationService.parserToken((String)parameters.get(0), tokenParams);
                        long creation = ((Date)tokenParams.get("iat")).getTime();
                        if (now - creation < 30000L) {
                            valid = true;
                            ServiceAdapter.setAuthorizationHeader((String)("Bearer " + (String)parameters.get(0)));
                        }
                    }
                } else {
                    userId = authenticationService.parserToken(authorizationHeader.substring("Bearer".length()).trim(), null);
                }
                if (!valid) {
                    requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)new RestErrorMessage("Authorization header must be provided")).build());
                    return;
                }
                ServiceAdapter.setCurrentUser((String)userId);
                requestContext.setProperty("userId", (Object)userId);
            }
            catch (ParseException e) {
                requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
            }
        }
    }
}

