/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.projectservice.v1_02;

import csbase.exception.OperationFailureException;
import csbase.server.services.openbusservice.OpenBusService;
import java.util.Properties;
import org.omg.CORBA.Object;
import scs.core.IComponent;
import tecgraf.openbus.data_service.core.v1_02.DataKeyWrapper;
import tecgraf.openbus.data_service.core.v1_02.IDataService;
import tecgraf.openbus.data_service.core.v1_02.IDataServiceHelper;
import tecgraf.openbus.data_service.core.v1_02.ServiceFailure;

public class FindService {
    private static String DATA_SOURCE_ID_PROPERTY_NAME = "openbus.data_source_id";
    private static final String REGISTERING_ENTITY_PROPERTY_NAME = "openbus.offer.entity";
    private static final String INTERFACE_PROPERTY_NAME = "openbus.component.interface";

    protected static IDataService find(DataKeyWrapper dataKey) throws ServiceFailure {
        IComponent component;
        String systemDeploymentId = dataKey.getSystemDeploymentId();
        String dataSourceId = dataKey.getDataSourceId();
        Properties properties = new Properties();
        properties.setProperty(REGISTERING_ENTITY_PROPERTY_NAME, systemDeploymentId);
        properties.setProperty(DATA_SOURCE_ID_PROPERTY_NAME, dataSourceId);
        properties.setProperty(INTERFACE_PROPERTY_NAME, IDataServiceHelper.id());
        try {
            component = OpenBusService.getInstance().findService(properties);
            if (component == null) {
                return null;
            }
        }
        catch (OperationFailureException e) {
            throw new ServiceFailure("Erro ao buscar o servi\u00e7o de dados.");
        }
        Object obj = component.getFacet(IDataServiceHelper.id());
        IDataService dataService = IDataServiceHelper.narrow((Object)obj);
        return dataService;
    }
}

