/**
 * $Id$
 */
package csbase.server.services.projectservice.v1_02;

import tecgraf.openbus.data_service.core.v1_02.DataAccessDenied;
import tecgraf.openbus.data_service.core.v1_02.DataDescription;
import tecgraf.openbus.data_service.core.v1_02.DataNotFound;
import tecgraf.openbus.data_service.core.v1_02.DataView;
import tecgraf.openbus.data_service.core.v1_02.IDataServiceOperations;
import tecgraf.openbus.data_service.core.v1_02.IDataServicePOA;
import tecgraf.openbus.data_service.core.v1_02.InvalidDataKey;
import tecgraf.openbus.data_service.core.v1_02.ServiceFailure;
import tecgraf.openbus.data_service.core.v1_02.UnsupportedView;
import csbase.server.Server;
import csbase.server.Service;
import csbase.server.services.openbusservice.OpenBusService;

/**
 * 
 * 
 * @author Tecgraf
 */
public class IDataServiceServant extends IDataServicePOA {

  /**
   * {@inheritDoc}
   */
  @Override
  public DataDescription getDataDescription(byte[] fKey) throws ServiceFailure,
    DataAccessDenied, DataNotFound, InvalidDataKey {
    DataValidation.checkUser(OpenBusService.getInstance().getRequesterUserId());
    Service.setUserId(OpenBusService.getInstance().getRequesterUserId());
    try {
      IDataServiceOperations service = ProjectDataService.getInstance();
      return service.getDataDescription(fKey);
    }
    catch (RuntimeException e) {
      Server.logSevereMessage(e.getMessage(), e);
      throw new ServiceFailure();
    }
    finally {
      Service.setUserId(null);
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public DataView getDataView(byte[] fKey, String fViewInterface)
    throws UnsupportedView, ServiceFailure, DataAccessDenied, DataNotFound,
    InvalidDataKey {
    DataValidation.checkUser(OpenBusService.getInstance().getRequesterUserId());
    Service.setUserId(OpenBusService.getInstance().getRequesterUserId());
    try {
      IDataServiceOperations service = ProjectDataService.getInstance();
      return service.getDataView(fKey, fViewInterface);
    }
    catch (RuntimeException e) {
      Server.logSevereMessage(e.getMessage(), e);
      throw new ServiceFailure();
    }
    finally {
      Service.setUserId(null);
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public DataView[] getDataViewSeq(byte[][] fKeys, String fViewInterface)
    throws UnsupportedView, ServiceFailure, DataAccessDenied, DataNotFound,
    InvalidDataKey {
    DataValidation.checkUser(OpenBusService.getInstance().getRequesterUserId());
    Service.setUserId(OpenBusService.getInstance().getRequesterUserId());
    try {
      IDataServiceOperations service = ProjectDataService.getInstance();
      return service.getDataViewSeq(fKeys, fViewInterface);
    }
    catch (RuntimeException e) {
      Server.logSevereMessage(e.getMessage(), e);
      throw new ServiceFailure();
    }
    finally {
      Service.setUserId(null);
    }
  }
}
