/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.projectservice;

import csbase.exception.InfoException;
import csbase.exception.PermissionException;
import csbase.exception.ServiceFailureException;
import csbase.logic.ClientProjectFile;
import csbase.logic.ClientProjectFileInfo;
import csbase.logic.ExternalUser;
import csbase.logic.FileLockEvent;
import csbase.logic.FileLockListenerInterface;
import csbase.logic.ProjectEvent;
import csbase.logic.ProjectFileInfo;
import csbase.logic.ProjectFileType;
import csbase.logic.ProjectFileTypeInfo;
import csbase.logic.SecureKey;
import csbase.logic.User;
import csbase.logic.Utilities;
import csbase.server.FileSystem;
import csbase.server.Server;
import csbase.server.Service;
import csbase.server.services.ftcservice.FTCRequester;
import csbase.server.services.ftcservice.FTCService;
import csbase.server.services.messageservice.MessageService;
import csbase.server.services.projectservice.FileConfig;
import csbase.server.services.projectservice.FileLockInterface;
import csbase.server.services.projectservice.FileLockManager;
import csbase.server.services.projectservice.ProjectService;
import csbase.server.services.projectservice.ProjectTemplate;
import csbase.server.services.projectservice.ServerProject;
import csbase.server.services.projectservice.UpdatableFileInfo;
import csbase.server.services.repositoryservice.IRepositoryFile;
import csbase.util.messages.Message;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.InvalidPathException;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import tecgraf.ftc.common.logic.RemoteFileChannelInfo;
import tecgraf.javautils.core.io.FileUtils;

class ServerProjectFile
extends FileConfig {
    private Object projectId;
    private static final HashMap<String, SoftReference<ServerProjectFile>> filesCache = new HashMap();
    private static final Comparator<ServerProjectFile> NAME_COMPARATOR = new Comparator<ServerProjectFile>(){

        @Override
        public int compare(ServerProjectFile o1, ServerProjectFile o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };

    static final synchronized ServerProjectFile buildFromCache(File file, Object projectId, ServerProjectFile parent) {
        ServerProjectFile spf;
        String key = file.getAbsolutePath();
        if (filesCache.containsKey(key) && (spf = filesCache.get(key).get()) != null) {
            if (spf.isRoot() || spf.parent.equals(parent)) {
                return spf;
            }
            String msg = "ServerProjectFile cache inv\u00e1lido: {0}. Cache.parent: {1} -> Actual.parent: {2}";
            Server.logSevereMessage(MessageFormat.format(msg, spf.getAbsolutePath(), spf.parent.getName(), parent.getName()));
            Arrays.stream(Thread.currentThread().getStackTrace()).forEach(System.out::println);
        }
        ServerProjectFile srvFile = new ServerProjectFile(file, projectId, parent);
        filesCache.put(key, new SoftReference<ServerProjectFile>(srvFile));
        return srvFile;
    }

    static final synchronized void deleteInCache(ServerProjectFile serverProjectFile) {
        String key = serverProjectFile.getAbsolutePath();
        filesCache.remove(key);
        if (serverProjectFile.isDirectory()) {
            ServerProjectFile[] children;
            for (ServerProjectFile child : children = serverProjectFile.getChildren()) {
                ServerProjectFile.deleteInCache(child);
            }
        }
    }

    static final synchronized void clearAllCache() {
        filesCache.clear();
    }

    public InputStream openInputStream() {
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            throw new ServiceFailureException(e.getMessage(), (Throwable)e);
        }
    }

    public OutputStream openOutputStream() {
        return this.openOutputStream(false);
    }

    public OutputStream openOutputStream(boolean append) {
        try {
            return new FileOutputStream(this.file, append);
        }
        catch (FileNotFoundException e) {
            throw new ServiceFailureException(e.getMessage(), (Throwable)e);
        }
    }

    private ServerProjectFile _createFile(String name, String type, Object userId) {
        if (ServerProjectFile.isControlledFileName(name)) {
            String infoMsg = this.getFormattedString("ProjectService.info.reserved.name", name);
            throw new InfoException(infoMsg);
        }
        this.checkTemplateForCreation(this, name, type);
        ProjectFileTypeInfo typeInfo = ProjectService.getInstance().getFileType(type);
        if (typeInfo.getCode().equals("UNKNOWN")) {
            typeInfo = ProjectService.getInstance().getTypeFromExtension(name, false);
        }
        File newFile = new File(this.file, name);
        try {
            newFile.toPath();
        }
        catch (InvalidPathException e) {
            String infoMsg = this.getFormattedString("ProjectService.error.template.path", name);
            throw new InfoException(infoMsg);
        }
        if (newFile.exists()) {
            String infoMsg = this.getFormattedString("ServerProjectFile.info.file.exists", name, this.getName());
            throw new InfoException(infoMsg);
        }
        try {
            if (typeInfo.isDirectory()) {
                if (!newFile.mkdir()) {
                    String errMsg = "ServerProjectFile:createDirectory: falha ao criar " + newFile.getAbsolutePath();
                    throw new ServiceFailureException(errMsg);
                }
            } else {
                newFile.createNewFile();
            }
            ServerProjectFile spf = ServerProjectFile.buildFromCache(newFile, this.projectId, this);
            spf.configure(typeInfo.getCode(), userId);
            return spf;
        }
        catch (IOException e) {
            String errMsg = "ServerProjectFile:create: erro ao criar " + newFile.getAbsolutePath();
            throw new ServiceFailureException(errMsg, (Throwable)e);
        }
    }

    private synchronized void configure(String type, Object userId) {
        try {
            long date;
            this.type = type;
            this.createdBy = userId;
            this.creationDate = date = Calendar.getInstance().getTimeInMillis();
            this.writeConfiguration();
            User user = User.getUser((Object)userId);
            String userName = user.getName();
            String userLogin = user.getLogin();
            if (userName == null) {
                userName = (String)userId;
            }
            String msg = this.getString("ServerProjectFile.file.created.by");
            msg = MessageFormat.format(msg, Utilities.getFormattedDate((long)date), userLogin, userName);
            this.appendDescription(msg);
        }
        catch (RemoteException e) {
            String errMsg = "ServerProjectFile:configure: ";
            throw new ServiceFailureException(errMsg, (Throwable)e);
        }
    }

    static ServerProjectFile createRoot(File rootDir, Object projectId) {
        return ServerProjectFile.buildFromCache(rootDir, projectId, null);
    }

    synchronized void makeSureExists() {
        if (!this.file.exists()) {
            String infoMsg = this.getFormattedString("ServerProjectFile.info.file.not.exists", this.file.getAbsolutePath());
            throw new InfoException(infoMsg);
        }
    }

    void rebuildDir() {
        this.makeSureExists();
        ProjectService projectService = ProjectService.getInstance();
        ClientProjectFile clientDir = projectService.buildClientProjectSubtree(this);
        ServerProjectFile.fireDirRefreshedEvent(this.projectId, this.getPath(), clientDir);
    }

    void refreshDir() {
        this.makeSureExists();
        ProjectService projectService = ProjectService.getInstance();
        ClientProjectFile clientDir = projectService.buildSingleClientProjectFile(this);
        ServerProjectFile.fireDirRefreshedEvent(this.projectId, this.getPath(), clientDir);
    }

    public synchronized void setUnderConstruction(boolean isUnderConstruction) {
        if (this.isUnderConstruction != isUnderConstruction) {
            this.isUnderConstruction = isUnderConstruction;
            this.writeConfiguration();
            ServerProjectFile.fireStateChangedEvent(this.projectId, this.file.getName(), this.getPath(), isUnderConstruction, new Long(this.getModificationDate()), new Long(this.size()), FileLockManager.getInstance().isLocked(this));
        }
    }

    private synchronized void setType(String type) {
        ProjectFileType pft = ProjectFileType.getFileType((String)type);
        if (this.isDirectory() && !pft.isDirectory()) {
            if (!"UNKNOWN".equals(pft.getCode())) {
                String errMsg = this.getFormattedString("ServerProjectFile.error.change.type.wrong.dir", this.getName(), pft.getDescription(), pft.getCode());
                throw new ServiceFailureException(errMsg);
            }
            pft = ProjectFileType.getFileType((String)"DIRECTORY_TYPE");
        }
        if (!this.isDirectory() && pft.isDirectory()) {
            String errMsg = this.getFormattedString("ServerProjectFile.error.change.type.wrong.file", this.getName(), pft.getDescription(), pft.getCode());
            throw new ServiceFailureException(errMsg);
        }
        this.type = pft.getCode();
        this.writeConfiguration();
    }

    public synchronized void changeType(String type) {
        this.checkTemplateForTypeChange(type);
        this.setType(type);
        ServerProjectFile.fireNewFileNameEvent(this.projectId, this.getPath(), this.getName(), this.type);
    }

    public String getName() {
        return this.file.getName();
    }

    public String[] getPath() {
        Stack<String> pathStack = new Stack<String>();
        ServerProjectFile spf = this;
        while (spf.parent != null) {
            pathStack.push(spf.getName());
            spf = spf.parent;
        }
        String[] pathArray = new String[pathStack.size()];
        for (int i = 0; i < pathArray.length; ++i) {
            pathArray[i] = (String)pathStack.pop();
        }
        return pathArray;
    }

    public String getAbsolutePath() {
        return this.file.getAbsolutePath();
    }

    public String getCanonicalPath() {
        try {
            return this.file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new ServiceFailureException("ServerProjectFile: Caminho can\u00f4nico do arquivo n\u00e3o p\u00f4de ser obtido", (Throwable)e);
        }
    }

    public String getType() {
        return this.type;
    }

    public ServerProjectFile getParent() {
        return this.parent;
    }

    public Object getProjectId() {
        return this.projectId;
    }

    public ServerProjectFile[] getChildren() {
        return this.getNewTree();
    }

    public ServerProjectFile[] getChildren(String fileType) {
        return this.getNewTree(fileType);
    }

    public synchronized ServerProjectFile getChild(String name) {
        if (!this.file.isDirectory()) {
            String errMsg = "ServerProjectFile:getChild: " + this.file.getAbsolutePath() + " n\u00e3o \u00e9 diret\u00f3rio";
            throw new ServiceFailureException(errMsg);
        }
        File child = new File(this.file, name);
        if (!child.exists()) {
            return null;
        }
        return ServerProjectFile.buildFromCache(child, this.projectId, this);
    }

    public synchronized boolean hasChildren() {
        if (!this.file.isDirectory()) {
            return false;
        }
        String[] childrenList = this.file.list(new FilenameFilter(){
            boolean foundOne = false;

            @Override
            public boolean accept(File dir, String childName) {
                if (this.foundOne || FileConfig.isControlledFileName(childName)) {
                    return false;
                }
                this.foundOne = true;
                return true;
            }
        });
        return childrenList != null && childrenList.length > 0;
    }

    public synchronized ServerProjectFile createFile(String name, String type, Object userId) {
        if (userId == null) {
            String errMsg = "ServerProjectFile:createFile: userId == null";
            throw new ServiceFailureException(errMsg);
        }
        if (!this.isDirectory()) {
            String infoMsg = this.getFormattedString("ServerProjectFile.info.create.file.not.directory", name, this.getAbsolutePath());
            throw new ServiceFailureException(infoMsg);
        }
        ServerProjectFile spf = this._createFile(name, type, userId);
        ServerProjectFile.fireNewFileEvent(this.projectId, spf);
        return spf;
    }

    public synchronized void createFiles(List<ProjectFileInfo> fileInfoList, Object userId, boolean notify) {
        if (fileInfoList == null) {
            String errMsg = "ServerProjectFile:createFiles: fileInfoList == null";
            throw new ServiceFailureException(errMsg);
        }
        if (fileInfoList.size() == 0) {
            String errMsg = "ServerProjectFile:createFiles: fileInfoList.size() == 0";
            throw new ServiceFailureException(errMsg);
        }
        if (userId == null) {
            String errMsg = "ServerProjectFile:createFiles: userId == null";
            throw new ServiceFailureException(errMsg);
        }
        if (!this.isDirectory()) {
            String infoMsg = this.getFormattedString("ServerProjectFile.info.create.files.not.directory", this.getAbsolutePath());
            throw new InfoException(infoMsg);
        }
        HashSet<ServerProjectFile> newFiles = new HashSet<ServerProjectFile>();
        for (int i = 0; i < fileInfoList.size(); ++i) {
            ServerProjectFile father = this;
            ProjectFileInfo childInfo = fileInfoList.get(i);
            if (childInfo == null) {
                String errMsg = "ServerProjectFile:createFiles: childInfo == null";
                throw new ServiceFailureException(errMsg);
            }
            String[] childPath = childInfo.getPath();
            if (childPath == null) {
                String errMsg = "ServerProjectFile:createFiles: childPath == null";
                throw new ServiceFailureException(errMsg);
            }
            if (childPath.length == 0) {
                String errMsg = "ServerProjectFile:createFiles: childPath.length == 0";
                throw new ServiceFailureException(errMsg);
            }
            boolean hasParentInEvent = false;
            String childType = childInfo.getType();
            for (int j = 0; j < childPath.length; ++j) {
                ServerProjectFile child = father.getChild(childPath[j]);
                if (child == null) {
                    child = j < childPath.length - 1 ? father._createFile(childPath[j], "DIRECTORY_TYPE", userId) : father._createFile(childPath[j], childType, userId);
                    if (!hasParentInEvent) {
                        hasParentInEvent = true;
                        newFiles.add(child);
                    }
                } else if (newFiles.contains(child)) {
                    hasParentInEvent = true;
                }
                father = child;
            }
        }
        if (notify) {
            ServerProjectFile[] filesArray = newFiles.toArray(new ServerProjectFile[newFiles.size()]);
            ServerProjectFile.fireNewFilesEvent(this.projectId, filesArray);
        }
    }

    private SecureKey getUserSecureKey() {
        Object k = ProjectService.getKey();
        if (k instanceof ExternalUser) {
            return null;
        }
        return (SecureKey)k;
    }

    private Object acquireLock() {
        Object lockId;
        FileLockManager lockManager = FileLockManager.getInstance();
        SecureKey key = null;
        if (!ProjectService.isInternalServerRequest()) {
            key = this.getUserSecureKey();
        }
        if (this.isDirectory()) {
            lockId = lockManager.acquireSharedLock(this, key);
            if (lockId == null) {
                String infoMsg = this.getFormattedString("ServerProjectFile.info.dir.locked", this.getName());
                throw new InfoException(infoMsg);
            }
            if (lockManager.getLockRefCount(this) > 1) {
                lockManager.releaseLock(this, lockId);
                String infoMsg = this.getFormattedString("ServerProjectFile.info.dir.locked", this.getName());
                throw new InfoException(infoMsg);
            }
        } else {
            lockId = lockManager.acquireExclusiveLock(this, key);
            if (lockId == null) {
                String infoMsg = this.getFormattedString("ServerProjectFile.info.file.locked", this.getName());
                throw new InfoException(infoMsg);
            }
        }
        return lockId;
    }

    public synchronized void rename(String name) {
        this.checkTemplateForRename(name);
        Object lockId = null;
        ServerProjectFile oldFile = this;
        boolean success = false;
        String oldAbsolutePath = this.getAbsolutePath();
        lockId = this.acquireLock();
        try {
            if (this.parent == null) {
                String infoMsg = this.getString("ServerProjectFile.info.rename.root");
                throw new InfoException(infoMsg);
            }
            if (FileConfig.isControlledFileName(name)) {
                String infoMsg = this.getFormattedString("ServerProjectFile.info.reserved.name", name);
                throw new InfoException(infoMsg);
            }
            File newFile = ServerProjectFile.renamedFile(this.file, name);
            if (newFile.exists()) {
                String infoMsg = this.getFormattedString("ServerProjectFile.info.file.exists", name);
                throw new InfoException(infoMsg);
            }
            String[] oldPath = this.getPath();
            ServerProjectFile.deleteInCache(this);
            success = this.rename(newFile);
            if (!success) {
                String errMsg = "ServerProjectFile:rename:  n\u00e3o foi poss\u00edvel renomear o arquivo " + this.getAbsolutePath() + " para " + newFile.getAbsolutePath();
                throw new ServiceFailureException(errMsg);
            }
            ServerProjectFile.fireNewFileNameEvent(this.projectId, oldPath, name, this.type);
        }
        catch (InvalidPathException e) {
            String infoMsg = this.getFormattedString("ProjectService.error.template.path", name);
            throw new InfoException(infoMsg);
        }
        finally {
            if (success) {
                FileLockManager.getInstance().releaseLock(oldAbsolutePath, lockId);
            } else {
                FileLockManager.getInstance().releaseLock(oldFile, lockId);
            }
        }
    }

    public synchronized void copy(ServerProjectFile directory) {
        String copyFileName = !this.isDirectory() && this.parent.getAbsolutePath().equals(directory.getAbsolutePath()) ? this.getCopyName() : this.getName();
        this.copy(directory, copyFileName);
    }

    public synchronized void copy(ServerProjectFile directory, String copyFileName) {
        this.checkTemplateForCreation(directory, copyFileName, this.getType());
        File newFile = new File(directory.file, copyFileName);
        if (newFile.exists()) {
            String infoMsg = this.getFormattedString("ServerProjectFile.info.file.exists", copyFileName, directory.getName());
            throw new InfoException(infoMsg);
        }
        if (this.isDirectory()) {
            if (this.equals(directory)) {
                String infoMsg = this.getFormattedString("ServerProjectFile.info.copy.into.equal", this.getName());
                throw new InfoException(infoMsg);
            }
            for (ServerProjectFile parent = directory.getParent(); parent != null; parent = parent.getParent()) {
                if (!this.equals(parent)) continue;
                String infoMsg = this.getFormattedString("ServerProjectFile.info.copy.into.descendant", this.getName(), directory.getName());
                throw new InfoException(infoMsg);
            }
        }
        if (!this.copyFile(newFile)) {
            String errMsg = String.format(this.getString("ServerProjectFile.error.copy"), copyFileName, directory.getName());
            throw new ServiceFailureException(errMsg);
        }
        ServerProjectFile spf = directory.getChild(copyFileName);
        Object TargetProjectId = spf.getProjectId();
        ServerProjectFile.fireNewFileEvent(TargetProjectId, spf);
    }

    private String getCopyName() {
        int maxCopyNumber = 0;
        ServerProjectFile father = this.getParent();
        ServerProjectFile[] brothers = father.getChildren();
        String[] parts = this.splitFileName();
        String preffix = parts[0];
        String extension = parts[2];
        for (int i = 0; i < brothers.length; ++i) {
            ServerProjectFile brother = brothers[i];
            String[] brotherParts = brother.splitFileName();
            if (!brotherParts[0].equals(preffix) || !brotherParts[2].equals(extension) || brotherParts[1].length() == 0) continue;
            try {
                int copyNumber = Integer.parseInt(brotherParts[1]);
                if (copyNumber <= maxCopyNumber) continue;
                maxCopyNumber = copyNumber;
                continue;
            }
            catch (NumberFormatException ex) {
                throw new ServiceFailureException("Erro ao construir o nome do arquivo.", (Throwable)ex);
            }
        }
        int copyNumber = maxCopyNumber + 1;
        String copyName = preffix + "_" + copyNumber;
        if (extension.length() != 0) {
            copyName = copyName + "." + extension;
        }
        return copyName;
    }

    private String[] splitFileName() {
        String sequencialCandidate;
        String name = this.getName();
        int ixLastUnderscore = name.lastIndexOf("_");
        int ixDot = name.lastIndexOf(".");
        int ixEndPreffix = name.length();
        String preffix = "";
        String sequencial = "";
        String extension = "";
        if (ixDot != -1) {
            extension = name.substring(ixDot + 1);
            name = name.substring(0, ixDot);
            ixEndPreffix = ixDot;
        }
        if ((ixLastUnderscore = name.lastIndexOf("_")) != -1 && (sequencialCandidate = name.substring(ixLastUnderscore + 1)).matches("\\d+")) {
            sequencial = sequencialCandidate;
            ixEndPreffix = ixLastUnderscore;
        }
        preffix = name.substring(0, ixEndPreffix);
        return new String[]{preffix, sequencial, extension};
    }

    public boolean isAncestorOf(ServerProjectFile otherFile) {
        return ServerProjectFile.isAncestor(this.getPath(), otherFile.getPath());
    }

    public static boolean isAncestor(String[] ancestorPath, String[] descendantPath) {
        if (ancestorPath == null || descendantPath == null) {
            return false;
        }
        if (ancestorPath.length >= descendantPath.length) {
            return false;
        }
        for (int i = 0; i < ancestorPath.length; ++i) {
            if (ancestorPath[i].equals(descendantPath[i])) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void move(ServerProjectFile directory) {
        this.checkTemplateForRemoval();
        this.checkTemplateForCreation(directory, this.getName(), this.getType());
        Object lockId = null;
        lockId = this.acquireLock();
        boolean success = false;
        File newFile = null;
        String oldAbsolutePath = this.getAbsolutePath();
        try {
            Object SourceProjectId = this.getProjectId();
            Object TargetProjectId = directory.getProjectId();
            if (SourceProjectId.equals(TargetProjectId) && this.isDirectory() && this.isAncestorOf(directory)) {
                String infoMsg = this.getFormattedString("ServerProjectFile.info.move.into.descendant", this.getName(), directory.getName(), this.getName());
                throw new InfoException(infoMsg);
            }
            if (SourceProjectId.equals(TargetProjectId) && this.isDirectory() && this.equals(directory)) {
                String infoMsg = this.getFormattedString("ServerProjectFile.info.move.into.equal", this.getName(), this.getName());
                throw new InfoException(infoMsg);
            }
            String[] oldPath = this.getPath();
            newFile = new File(directory.file, this.file.getName());
            if (newFile.exists()) {
                String infoMsg = this.getFormattedString("ServerProjectFile.info.file.exists", this.getName(), directory.getName());
                throw new InfoException(infoMsg);
            }
            ServerProjectFile.deleteInCache(this);
            success = this.rename(newFile);
            if (!success) {
                String errMsg = "ServerProjectFile:move: falha ao mover " + this.getAbsolutePath() + " para " + directory.file.getAbsolutePath();
                throw new ServiceFailureException(errMsg);
            }
            this.parent = directory;
            this.projectId = TargetProjectId;
            ServerProjectFile.fireNewFileEvent(TargetProjectId, this);
            ServerProjectFile.fireFileDeletedEvent(SourceProjectId, oldPath);
        }
        finally {
            if (success) {
                FileLockManager.getInstance().releaseLock(oldAbsolutePath, lockId);
            } else {
                FileLockManager.getInstance().releaseLock(this, lockId);
            }
        }
    }

    public synchronized void remove(boolean checkTemplate) {
        String[] path = this.getPath();
        if (!this.removeFile(checkTemplate)) {
            String errMsg = "ServerProjectFile:remove: falha ao remover " + this.getAbsolutePath();
            throw new ServiceFailureException(errMsg);
        }
        if (path.length > 0) {
            ServerProjectFile.fireFileDeletedEvent(this.projectId, path);
        }
    }

    public ClientProjectFileInfo getUpdatedInfo() {
        return new ClientProjectFileInfo(this.getType(), this.size(), this.getModificationDate(), this.isUnderConstruction(), this.isLocked());
    }

    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    public boolean isUnderConstruction() {
        return this.isUnderConstruction;
    }

    public boolean isLocked() {
        return FileLockManager.getInstance().isLocked(this);
    }

    public synchronized String getDescription() {
        return this.readDescription();
    }

    public synchronized void setDescription(String text) {
        this.writeDescription(text, false);
    }

    public synchronized void appendDescription(String text) {
        this.writeDescription(text, true);
    }

    public Object acquireExclusiveLock() {
        Object lockId;
        SecureKey key = null;
        if (!ProjectService.isInternalServerRequest()) {
            key = this.getUserSecureKey();
        }
        if ((lockId = FileLockManager.getInstance().acquireExclusiveLock(this, key)) != null) {
            this.notifyLockStatusChanged();
        }
        return lockId;
    }

    public Object acquireExclusiveLock(FileLockListenerInterface listener, long timeout) {
        SecureKey key = null;
        if (!ProjectService.isInternalServerRequest()) {
            key = this.getUserSecureKey();
        }
        InternalFileLockListener internalListener = new InternalFileLockListener(listener, key);
        return FileLockManager.getInstance().acquireExclusiveLock(this, key, internalListener, timeout);
    }

    public Object acquireSharedLock() {
        Object lockId;
        SecureKey key = null;
        if (!ProjectService.isInternalServerRequest()) {
            key = this.getUserSecureKey();
        }
        if ((lockId = FileLockManager.getInstance().acquireSharedLock(this, key)) != null) {
            this.notifyLockStatusChanged();
        }
        return lockId;
    }

    public Object acquireSharedLock(FileLockListenerInterface listener, long timeout) {
        SecureKey key = null;
        if (!ProjectService.isInternalServerRequest()) {
            key = this.getUserSecureKey();
        }
        InternalFileLockListener internalListener = new InternalFileLockListener(listener, key);
        return FileLockManager.getInstance().acquireSharedLock(this, key, internalListener, timeout);
    }

    public int releaseLock(Object lockId) {
        int lockRefCount = FileLockManager.getInstance().releaseLock(this, lockId);
        if (lockRefCount == 0) {
            this.notifyLockStatusChanged();
        }
        return lockRefCount;
    }

    public int forceReleaseLock() {
        int lockRefCount = FileLockManager.getInstance().forceReleaseLock(this);
        if (lockRefCount == 0) {
            this.notifyLockStatusChanged();
        }
        return lockRefCount;
    }

    public Object whoCreated() {
        return this.createdBy;
    }

    public static String findFileProjectId(File file) {
        ProjectService projectService = ProjectService.getInstance();
        File rootDir = new File(projectService.getProjectRepositoryPath());
        try {
            String path = rootDir.getCanonicalPath();
            return ServerProjectFile.findFileProjectIdFromDir(file, path);
        }
        catch (IOException ioe) {
            String err = "Erro ao obter o caminho absoluto para o rep. de projetos";
            Server.logSevereMessage(err, ioe);
            return null;
        }
    }

    private static String findFileProjectIdFromDir(File file, String dir) {
        String relativePath = ServerProjectFile.findFilePath(file, dir);
        if (relativePath == null) {
            return null;
        }
        String[] path = FileUtils.splitPath((String)relativePath);
        return path[0] + File.separator + path[1];
    }

    public static String[] findFileRelativePath(File file) {
        ProjectService projectService = ProjectService.getInstance();
        String path = ServerProjectFile.findFilePath(file, projectService.getProjectRepositoryPath());
        if (path == null) {
            return null;
        }
        String[] totalPath = FileUtils.splitPath((String)path);
        String[] relPath = new String[totalPath.length - 1];
        for (int i = 0; i < relPath.length; ++i) {
            relPath[i] = totalPath[i + 1];
        }
        return relPath;
    }

    private static String findFilePath(File file, String dir) {
        int index;
        String path = file.getPath();
        if (dir.charAt(dir.length() - 1) != File.separatorChar) {
            dir = dir + File.separator;
        }
        if ((index = path.indexOf(dir)) == -1) {
            return null;
        }
        return path.substring(index + dir.length());
    }

    public long size() {
        return this.file.length();
    }

    public long getModificationDate() {
        return this.file.lastModified();
    }

    public RemoteFileChannelInfo openChannel(boolean isReadOnly) {
        try {
            String userId = Service.getUser().getLogin();
            Object key = Service.getKey();
            String sessionKey = key == null ? null : key.toString();
            Requester req = new Requester(userId, sessionKey);
            File f = new File(this.file.getAbsolutePath());
            return FTCService.getInstance().createFileChannelInfo((FTCRequester)req, f, isReadOnly);
        }
        catch (Exception e) {
            String errMsg = "Falha ao construir informa\u00e7\u00e3o de canal para " + this.file.getAbsolutePath();
            throw new ServiceFailureException(errMsg, (Throwable)e);
        }
    }

    public String toString() {
        String text = "";
        text = text + "File: " + this.file.getAbsolutePath() + "\n";
        if (this.parent != null) {
            text = text + "Parent: " + this.parent.getAbsolutePath() + "\n";
        }
        text = text + "UnderConstruction: " + this.isUnderConstruction + "\n";
        text = text + "Type : " + this.type + "\n";
        text = text + "CreatedBy:" + this.createdBy + "\n";
        text = text + "Project :" + this.projectId + "\n";
        return text;
    }

    public static ServerProjectFile testFile(Object projectId, String[] path) {
        ServerProject sp = ServerProject.getProject(projectId);
        if (sp == null) {
            String infoMsg = ProjectService.getInstance().getFormattedString("ServerProjectFile.info.project.not.open", new Object[]{ServerProject.getProjectName(projectId)});
            throw new InfoException(infoMsg);
        }
        ServerProjectFile spf = sp.getTree();
        for (int i = 0; spf != null && i < path.length; ++i) {
            File descriptionFile;
            ServerProjectFile parent;
            if (path[i] == null || path[i].trim().equals("") || (spf = (parent = spf).getChild(path[i])) != null || i != path.length - 1) continue;
            String parentPath = parent.getCanonicalPath();
            String filePath = parentPath + File.separator + path[path.length - 1];
            File file = new File(filePath);
            File configFile = ServerProjectFile.renamedConfigFile(file);
            if (configFile.exists()) {
                configFile.delete();
            }
            if ((descriptionFile = FileConfig.renamedDescriptionFile(file)).exists()) {
                descriptionFile.delete();
            }
            return null;
        }
        return spf;
    }

    public static ServerProjectFile findFile(Object projectId, String[] path) {
        ServerProjectFile spf = ServerProjectFile.testFile(projectId, path);
        if (spf == null) {
            ProjectService service = ProjectService.getInstance();
            String prjName = ServerProject.getProjectName(projectId);
            String dirName = FileUtils.joinPath((String)"/", (String[])Arrays.copyOf(path, path.length - 1));
            Object user = ServerProject.getOwnerId(projectId);
            String infoMsg = service.getFormattedString("ServerProjectFile.info.file.not.found", new Object[]{path[path.length - 1], dirName.isEmpty() ? "/" : dirName, prjName, user});
            throw new InfoException(infoMsg);
        }
        return spf;
    }

    private static void fireStateChangedEvent(Object projectId, String fileName, String[] path, boolean isUnderConstruction, Long modificationDate, Long size, boolean locked) {
        Object[] arg = new Object[]{path, fileName, isUnderConstruction, modificationDate, size, locked};
        try {
            String[] users = ProjectService.getInstance().getUserToNotify(projectId);
            MessageService.getInstance().send(new Message((Serializable)ProjectEvent.makeEvent((Object)projectId, (int)7, (Object[])arg)), users);
        }
        catch (RemoteException e) {
            Server.logSevereMessage("Erro ao notificar os usu\u00e1rios do projeto " + projectId + ".", e);
        }
    }

    private static void fireNewFileEvent(Object projectId, ServerProjectFile file) {
        Object[] args = new Object[2];
        args[0] = null == file.getParent() ? new String[0] : file.getParent().getPath();
        ProjectService projectService = ProjectService.getInstance();
        args[1] = projectService.buildClientProjectSubtree(file);
        try {
            String[] users = ProjectService.getInstance().getUserToNotify(projectId);
            MessageService.getInstance().send(new Message((Serializable)ProjectEvent.makeEvent((Object)projectId, (int)3, (Object[])args)), users);
        }
        catch (RemoteException e) {
            Server.logSevereMessage("Erro ao notificar os usu\u00e1rios do projeto " + projectId + ".", e);
        }
    }

    private static void fireNewFilesEvent(Object projectId, ServerProjectFile[] files) {
        String[][] paths = new String[files.length][];
        ClientProjectFile[] clientProjectFiles = new ClientProjectFile[files.length];
        for (int fileInx = 0; fileInx < files.length; ++fileInx) {
            ServerProjectFile file = files[fileInx];
            paths[fileInx] = null == file.getParent() ? new String[0] : file.getParent().getPath();
            ProjectService projectService = ProjectService.getInstance();
            clientProjectFiles[fileInx] = projectService.buildClientProjectSubtree(file);
        }
        Object[] args = new Object[]{paths, clientProjectFiles};
        try {
            String[] users = ProjectService.getInstance().getUserToNotify(projectId);
            MessageService.getInstance().send(new Message((Serializable)ProjectEvent.makeEvent((Object)projectId, (int)11, (Object[])args)), users);
        }
        catch (RemoteException e) {
            Server.logSevereMessage("Erro ao notificar os usu\u00e1rios do projeto " + projectId + ".", e);
        }
    }

    private static void fireFileDeletedEvent(Object projectId, String[] path) {
        Object[] arg = new Object[]{path};
        try {
            String[] users = ProjectService.getInstance().getUserToNotify(projectId);
            MessageService.getInstance().send(new Message((Serializable)ProjectEvent.makeEvent((Object)projectId, (int)4, (Object[])arg)), users);
        }
        catch (RemoteException e) {
            Server.logSevereMessage("Erro ao notificar os usu\u00e1rios do projeto " + projectId + ".", e);
        }
    }

    private static void fireNewFileNameEvent(Object projectId, String[] path, String newName, String newType) {
        Object[] arg = new Object[]{path, newName, newType};
        try {
            String[] users = ProjectService.getInstance().getUserToNotify(projectId);
            MessageService.getInstance().send(new Message((Serializable)ProjectEvent.makeEvent((Object)projectId, (int)5, (Object[])arg)), users);
        }
        catch (RemoteException e) {
            Server.logSevereMessage("Erro ao notificar os usu\u00e1rios do projeto " + projectId + ".", e);
        }
    }

    private static void fireDirRefreshedEvent(Object projectId, String[] path, ClientProjectFile dir) {
        Object[] arg = new Object[]{path, dir};
        try {
            String[] users = ProjectService.getInstance().getUserToNotify(projectId);
            MessageService.getInstance().send(new Message((Serializable)ProjectEvent.makeEvent((Object)projectId, (int)12, (Object[])arg)), users);
        }
        catch (RemoteException e) {
            Server.logSevereMessage("Erro ao notificar os usu\u00e1rios do projeto " + projectId + ".", e);
        }
    }

    private void notifyLockStatusChanged() {
        try {
            boolean isLocked = FileLockManager.getInstance().isLocked(this);
            ServerProjectFile.fireStateChangedEvent(this.getProjectId(), this.getName(), this.getPath(), this.isUnderConstruction(), this.getModificationDate(), this.size(), isLocked);
        }
        catch (Exception e) {
            Server.logWarningMessage("Falha na notifica\u00e7\u00e3o de bloqueio/desbloqueio de lock do arquivo " + this.file.getAbsolutePath());
        }
    }

    /*
     * Exception decompiling
     */
    private String rawGetDescription() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String readDescription() {
        String fmt = this.getString("ProjectService.error.read.description");
        try {
            String desc = this.rawGetDescription();
            return desc == null ? "" : desc;
        }
        catch (IOException ioe) {
            String fileName = this.getName();
            File descFile = ServerProjectFile.renamedDescriptionFile(this.file);
            String path = descFile.getAbsolutePath();
            String exMsg = ioe.getMessage();
            String err = String.format(fmt, fileName, path, exMsg);
            return err;
        }
    }

    private void writeDescription(String text, boolean append) {
        String prefix = "----------------------------------\n";
        String sufix = "\n\n";
        String newText = "----------------------------------\n" + text + "\n\n";
        try {
            if (append) {
                String desc = this.rawGetDescription();
                String newDescription = desc + newText;
                this.rawWriteDescription(newDescription);
            } else {
                this.rawWriteDescription(newText);
            }
        }
        catch (IOException e) {
            String fileName = this.getName();
            String fmt = "writeDescription: falha ao escrever em '%s'!";
            String err = String.format("writeDescription: falha ao escrever em '%s'!", fileName);
            throw new ServiceFailureException(err, (Throwable)e);
        }
    }

    private void rawWriteDescription(String newDescription) throws IOException {
        File descFile = ServerProjectFile.renamedDescriptionFile(this.file);
        Server server = Server.getInstance();
        Charset charset = server.getSystemDefaultCharset();
        try (FileOutputStream fileStream = new FileOutputStream(descFile);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fileStream, charset);){
            writer.write(newDescription);
            writer.flush();
        }
    }

    private void appendDirectlyToDescriptionFile(String text, File descFile) throws IOException {
        Server server = Server.getInstance();
        Charset charset = server.getSystemDefaultCharset();
        try (FileInputStream inStream = new FileInputStream(descFile);
             InputStreamReader inReader = new InputStreamReader((InputStream)inStream, charset);
             BufferedReader inBuffReader = new BufferedReader(inReader);
             FileOutputStream outStream = new FileOutputStream(descFile);
             OutputStreamWriter outWriter = new OutputStreamWriter((OutputStream)outStream, charset);){
            StringBuffer contentBuffer = new StringBuffer();
            String line = inBuffReader.readLine();
            while (line != null) {
                contentBuffer = contentBuffer.append(line + "\n");
                line = inBuffReader.readLine();
            }
            contentBuffer = contentBuffer.append(text + "\n");
            String content = contentBuffer.toString();
            outWriter.write(content);
            outWriter.flush();
        }
    }

    private void sortChildren(List<ServerProjectFile> children) {
        Collections.sort(children, NAME_COMPARATOR);
    }

    private ServerProjectFile[] getNewTree() {
        return this.getNewTree(null);
    }

    private ServerProjectFile[] getNewTree(String type) {
        if (!this.file.isDirectory()) {
            String errMsg = "ServerProjectFile:buildTree: " + this.file.getAbsolutePath() + " n\u00e3o \u00e9 diret\u00f3rio";
            throw new ServiceFailureException(errMsg);
        }
        File[] files = this.getFileListWithoutControlFiles();
        ArrayList<ServerProjectFile> children = new ArrayList<ServerProjectFile>();
        for (File child : files) {
            ServerProjectFile spf = ServerProjectFile.buildFromCache(child, this.projectId, this);
            File cfg = spf.getConfigFile();
            if (cfg == null || !cfg.exists()) {
                ProjectFileTypeInfo typeInfo = ProjectService.getInstance().getTypeFromExtension(spf.getName(), spf.isDirectory());
                spf.setType(typeInfo.getCode());
            }
            if (type != null && !type.equals(spf.getType())) continue;
            children.add(spf);
        }
        this.sortChildren(children);
        return children.toArray(new ServerProjectFile[children.size()]);
    }

    private File[] getFileListWithoutControlFiles() {
        return this.file.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String childName) {
                return !FileConfig.isControlledFileName(childName);
            }
        });
    }

    private boolean rename(File newFile) {
        ProjectService srv = ProjectService.getInstance();
        File parentDir = new File(newFile.getParent());
        parentDir.mkdirs();
        if (!this.file.exists()) {
            Server.logSevereMessage("Imposs\u00edvel localizar [" + this.file.getAbsolutePath() + "] para fazer o rename!");
            return false;
        }
        if (!this.move(this.file, newFile) && srv != null) {
            Server.logSevereMessage("Imposs\u00edvel renomear de [" + this.file.getAbsolutePath() + "] para [" + newFile.getAbsolutePath() + "]");
            return false;
        }
        File configFile = this.getConfigFile();
        File newConfigFile = ServerProjectFile.renamedConfigFile(newFile);
        if (configFile.exists() && !this.move(configFile, newConfigFile)) {
            String errMsg = "ServerProjectFile:rename: falha ao mover " + configFile.getAbsolutePath() + " para " + newConfigFile.getAbsolutePath();
            if (!this.move(newFile, this.file)) {
                errMsg = errMsg + "\nServerProjectFile:rename: falha ao mover " + newFile.getAbsolutePath() + " de volta para " + this.getAbsolutePath();
                configFile.delete();
                configFile = newConfigFile;
                this.writeConfiguration();
            }
            if (srv != null) {
                Server.logSevereMessage(errMsg);
            }
            return false;
        }
        File descrFile = ServerProjectFile.renamedDescriptionFile(this.file);
        File newDescrFile = ServerProjectFile.renamedDescriptionFile(newFile);
        if (descrFile.exists()) {
            if (!this.move(descrFile, newDescrFile)) {
                String errMsg = "ServerProjectFile:rename: falha ao mover " + descrFile.getAbsolutePath() + " de volta para " + newDescrFile.getAbsolutePath();
                if (srv != null) {
                    Server.logSevereMessage(errMsg);
                }
                descrFile.delete();
                return false;
            }
            descrFile = newDescrFile;
        }
        this.file = newFile;
        return true;
    }

    private boolean move(File from, File to) {
        if (!from.renameTo(to)) {
            return FileSystem.move(from, to);
        }
        return true;
    }

    private boolean copyFile(File newFile) {
        if (this.file.isDirectory()) {
            return this.copyDirectory(newFile);
        }
        return this.copyRegularFile(newFile);
    }

    private boolean copyDirectory(File newFile) {
        if (!newFile.mkdirs()) {
            String errMsg = "ServerProjectFile:copyFile: erro na cria\u00e7\u00e3o de diret\u00f3rio " + newFile.getAbsolutePath();
            Server.logWarningMessage(errMsg);
            return false;
        }
        ServerProjectFile[] children = this.getChildren();
        boolean success = true;
        int n = children.length;
        for (int i = 0; i < n; ++i) {
            File newChildFile = new File(newFile, children[i].file.getName());
            success = children[i].copyFile(newChildFile);
            if (success) continue;
            String errMsg = "ServerProjectFile:copyFile: erro na c\u00f3pia do filho " + children[i].getAbsolutePath() + " para " + newChildFile.getAbsolutePath();
            Server.logWarningMessage(errMsg);
            break;
        }
        if (success) {
            return this.copyConfigurationFiles(newFile);
        }
        return false;
    }

    private boolean copyRegularFile(File newFile) {
        if (!FileSystem.copyFile(this.file, newFile)) {
            String errMsg = "ServerProjectFile:copyFile: erro na c\u00f3pia f\u00edsica de " + this.file.getAbsolutePath() + " para " + newFile.getAbsolutePath();
            Server.logWarningMessage(errMsg);
            return false;
        }
        return this.copyConfigurationFiles(newFile);
    }

    private boolean copyConfigurationFiles(File newFile) {
        File parentFile = newFile.getParentFile();
        String newFileName = newFile.getName();
        File configFile = this.getConfigFile();
        File newConfigFile = new File(parentFile, ServerProjectFile.createConfigFileName(newFileName));
        if (configFile.exists() && !FileSystem.copyFile(configFile, newConfigFile)) {
            String errMsg = "ServerProjectFile:copyFile: erro na c\u00f3pia de " + configFile.getAbsolutePath() + " para " + newConfigFile.getAbsolutePath();
            Server.logWarningMessage(errMsg);
            newConfigFile.delete();
            newFile.delete();
            return false;
        }
        return this.copyDescriptionFile(this.file, newFile);
    }

    private boolean copyDescriptionFile(File from, File to) {
        File descrFile = ServerProjectFile.renamedDescriptionFile(from);
        File newDescrFile = ServerProjectFile.renamedDescriptionFile(to);
        if (descrFile.exists() && !FileSystem.copyFile(descrFile, newDescrFile)) {
            String errMsg = "ServerProjectFile:copyDescriptionFile: erro na c\u00f3pia de " + descrFile.getAbsolutePath() + " para " + newDescrFile.getAbsolutePath();
            Server.logSevereMessage(errMsg);
            newDescrFile.delete();
            return false;
        }
        try {
            if (!newDescrFile.exists()) {
                newDescrFile.createNewFile();
            }
            User user = Service.getUser();
            String userName = "";
            if (user != null) {
                userName = user.getName();
            }
            String message = "Em " + Utilities.getFormattedDate((long)new Date().getTime()) + "\nArquivo copiado por " + userName + ".\n";
            this.appendDirectlyToDescriptionFile(message, newDescrFile);
        }
        catch (Exception e) {
            String errMsg = "ServerProjectFile:copyDescriptionFile: erro ao escrever no arquivo de configura\u00e7\u00e3o: " + newDescrFile.getAbsolutePath();
            Server.logSevereMessage(errMsg);
        }
        return true;
    }

    private static boolean pruneDirectory(File file) {
        if (!file.exists()) {
            return true;
        }
        if (file.isDirectory()) {
            File[] fileList = file.listFiles();
            if (fileList.length > 0) {
                for (int i = 0; i < fileList.length; ++i) {
                    if (fileList[i].isDirectory()) {
                        ServerProjectFile.pruneDirectory(fileList[i]);
                        continue;
                    }
                    fileList[i].delete();
                }
            }
            return file.delete();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeFile(boolean checkTemplate) {
        if (checkTemplate) {
            this.checkTemplateForRemoval();
        }
        Object lockId = null;
        lockId = this.acquireLock();
        try {
            File descrFile;
            File configFile;
            if (this.file.isFile()) {
                if (!this.file.delete()) {
                    String errMsg = "ServerProjectFile:remove: " + this.getAbsolutePath() + " n\u00e3o pode ser removido devido a falha ao apagar o arquivo " + this.file.getAbsolutePath();
                    Server.logWarningMessage(errMsg);
                    boolean bl = false;
                    return bl;
                }
            } else if (this.file.isDirectory() && !ServerProjectFile.pruneDirectory(this.file)) {
                String errMsg = "ServerProjectFile:remove: " + this.getAbsolutePath() + " n\u00e3o pode ser removido devido a falha ao apagar o arquivo " + this.file.getAbsolutePath();
                Server.logWarningMessage(errMsg);
                boolean bl = false;
                return bl;
            }
            if ((configFile = this.getConfigFile()) != null) {
                configFile.delete();
            }
            if ((descrFile = ServerProjectFile.renamedDescriptionFile(this.file)).exists()) {
                descrFile.delete();
            }
            ServerProjectFile.deleteInCache(this);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            Server.logSevereMessage(e.getMessage(), e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (lockId != null) {
                FileLockManager.getInstance().releaseLock(this, lockId);
            }
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof ServerProjectFile)) {
            return false;
        }
        ServerProjectFile other = (ServerProjectFile)o;
        return this.file.equals(other.file);
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    private ServerProjectFile(File file, Object projectId, ServerProjectFile parent) {
        super(file);
        this.projectId = projectId;
        this.parent = parent;
        this.readConfiguration();
    }

    public synchronized void setModificationDate(long date) {
        this.file.setLastModified(date);
    }

    private String getString(String key) {
        ProjectService projectService = ProjectService.getInstance();
        return projectService.getString(key);
    }

    private String getFormattedString(String key, Object ... objects) {
        ProjectService projectService = ProjectService.getInstance();
        return projectService.getFormattedString(key, objects);
    }

    public UpdatableFileInfo getUpdatableFileInfo() {
        return this.updatableFileInfo;
    }

    public synchronized void setUpdatableFileInfo(UpdatableFileInfo updatableFileInfo) {
        if (updatableFileInfo == null) {
            throw new IllegalArgumentException("As informa\u00e7\u00f5es sobre o arquivo n\u00e3o podem ter valor null.");
        }
        if (this.updatableFileInfo != null && this.updatableFileInfo.equals(updatableFileInfo)) {
            return;
        }
        this.updatableFileInfo = updatableFileInfo;
        this.writeConfiguration();
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    private void checkWriteAccess() {
        ServerProject project = ServerProject.getProject(this.projectId);
        if (!project.userHasAccessRW(Service.getUser().getId())) {
            String templateMsg = this.isDirectory() ? this.getString("ServerProjectFile.error.access.write.directory") : this.getString("ServerProjectFile.error.access.write.file");
            String message = String.format(templateMsg, FileUtils.joinPath((String[])this.getPath()), project.getName());
            throw new PermissionException(message);
        }
    }

    private ProjectFileInfo getProjectFileInfo() {
        if (this.isRoot()) {
            return new ProjectFileInfo(new String[]{""}, this.getType());
        }
        return new ProjectFileInfo(this.getPath(), this.getType());
    }

    private void checkTemplateForTypeChange(String newType) {
        ServerProject project = ServerProject.getProject(this.projectId);
        for (ProjectTemplate template : project.getProjectTemplates()) {
            if (template.canChangeType(this, newType)) continue;
            String key = "ServerProjectFile.error.template.newType";
            String path = FileUtils.joinPath((boolean)true, (char)File.separatorChar, (String[])this.getPath());
            String infoMsg = this.getFormattedString(key, this.getName(), newType, path);
            throw new PermissionException(infoMsg);
        }
    }

    private void checkTemplateForCreation(ServerProjectFile directory, String name, String type) {
        ServerProject project = ServerProject.getProject(this.projectId);
        for (ProjectTemplate template : project.getProjectTemplates()) {
            if (template.canCreate(this, name, type)) continue;
            String key = "ServerProjectFile.error.template.create";
            String path = FileUtils.joinPath((boolean)true, (char)File.separatorChar, (String[])directory.getPath());
            String infoMsg = this.getFormattedString(key, name, type, path);
            throw new PermissionException(infoMsg);
        }
    }

    private void checkTemplateForRename(String newName) {
        ServerProject project = ServerProject.getProject(this.projectId);
        for (ProjectTemplate template : project.getProjectTemplates()) {
            if (template.canRename(this, newName)) continue;
            String key = "ServerProjectFile.error.template.rename";
            String path = FileUtils.joinPath((boolean)true, (char)File.separatorChar, (String[])this.getPath());
            String infoMsg = this.getFormattedString(key, this.getName(), newName, path);
            throw new PermissionException(infoMsg);
        }
    }

    private void checkTemplateForRemoval() {
        ServerProject project = ServerProject.getProject(this.projectId);
        for (ProjectTemplate template : project.getProjectTemplates()) {
            if (template.canDelete(this)) continue;
            String key = "ServerProjectFile.error.template.delete";
            String path = FileUtils.joinPath((boolean)true, (char)File.separatorChar, (String[])this.getPath());
            String infoMsg = this.getFormattedString(key, this.getName(), path);
            throw new PermissionException(infoMsg);
        }
    }

    class InternalFileLockListener
    implements FileLockListenerInterface {
        FileLockListenerInterface externalListener;
        SecureKey sessionKey;

        InternalFileLockListener(FileLockListenerInterface externalListener, SecureKey sessionKey) {
            this.externalListener = externalListener;
            this.sessionKey = sessionKey;
        }

        public void fileLockExpired(Object lockId) throws RemoteException {
            if (this.externalListener != null) {
                this.externalListener.fileLockExpired(lockId);
            }
            if (this.sessionKey != null) {
                User user = Service.getUser();
                MessageService.getInstance().send(new Message((Serializable)new FileLockEvent(lockId, false)), (String)user.getId());
            }
        }

        public void fileLocked(Object lockId) throws RemoteException {
            try {
                if (this.externalListener != null) {
                    this.externalListener.fileLocked(lockId);
                }
                if (this.sessionKey != null) {
                    User user = Service.getUser();
                    MessageService.getInstance().send(new Message((Serializable)new FileLockEvent(lockId, true)), (String)user.getId());
                }
                ServerProjectFile.this.notifyLockStatusChanged();
            }
            catch (RemoteException e) {
                Server.logSevereMessage("Falha na notifica\u00e7\u00e3o de lock obtido. Pedido de lock: " + ServerProjectFile.this.getName(), e);
                ServerProjectFile.this.releaseLock(lockId);
            }
        }
    }

    private class Requester
    implements FTCRequester {
        private String userId = null;
        private String sessionKey = null;
        private boolean readOnly;

        Requester(String userId, String sessionKey) {
            this.userId = userId;
            this.sessionKey = sessionKey;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public FileChannel createFileChannel(IRepositoryFile file, boolean readOnly) throws Exception {
            try {
                String mode;
                this.readOnly = readOnly;
                Service.setUserId(this.userId);
                if (readOnly) {
                    mode = "r";
                } else {
                    try {
                        ServerProjectFile.this.checkWriteAccess();
                    }
                    catch (PermissionException e) {
                        Server.logSevereMessage("Sem permiss\u00e3o para " + this.userId + " acessar o arquivo: " + ServerProjectFile.this.getAbsolutePath(), e);
                        FileChannel fileChannel = null;
                        Service.setUserId(null);
                        return fileChannel;
                    }
                    if (this.sessionKey != null) {
                        FileLockInterface.LockStatus lockStatus = FileLockManager.getInstance().isLocked(ServerProjectFile.this, this.sessionKey);
                        if (lockStatus == FileLockInterface.LockStatus.LOCKED_BY_OTHERS) {
                            Server.logSevereMessage("Arquivo bloqueado: " + ServerProjectFile.this.getAbsolutePath());
                            FileChannel fileChannel = null;
                            return fileChannel;
                        }
                    } else if (FileLockManager.getInstance().isLocked(ServerProjectFile.this)) {
                        Server.logSevereMessage("Arquivo bloqueado: " + ServerProjectFile.this.getAbsolutePath());
                        FileChannel lockStatus = null;
                        return lockStatus;
                    }
                    mode = "rw";
                }
                try {
                    FileChannel channel = file.getFileChannel(mode);
                    if (!readOnly) {
                        ServerProjectFile.this.setUnderConstruction(true);
                    }
                    FileChannel fileChannel = channel;
                    return fileChannel;
                }
                catch (FileNotFoundException e) {
                    Server.logSevereMessage("Arquivo n\u00e3o encontrado: " + ServerProjectFile.this.getAbsolutePath(), e);
                    FileChannel fileChannel = null;
                    Service.setUserId(null);
                    return fileChannel;
                }
            }
            finally {
                Service.setUserId(null);
            }
        }

        @Override
        public void fileChannelClosed(IRepositoryFile file) throws Exception {
            try {
                Service.setUserId(this.userId);
                try {
                    file.close();
                }
                catch (IOException e) {
                    Server.logSevereMessage("Erro ao tentar fechar arquivo utilizado pelo servidor de arquivos: " + ServerProjectFile.this.getAbsolutePath(), e);
                }
                if (!this.readOnly) {
                    ServerProjectFile.this.setUnderConstruction(false);
                }
            }
            finally {
                Service.setUserId(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isLocked(IRepositoryFile file) throws Exception {
            try {
                Service.setUserId(this.userId);
                if (this.sessionKey == null) {
                    boolean bl = FileLockManager.getInstance().isLocked(ServerProjectFile.this);
                    return bl;
                }
                FileLockInterface.LockStatus lockStatus = FileLockManager.getInstance().isLocked(ServerProjectFile.this, this.sessionKey);
                boolean bl = lockStatus == FileLockInterface.LockStatus.LOCKED_BY_OTHERS;
                return bl;
            }
            finally {
                Service.setUserId(null);
            }
        }
    }
}

