/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.restservice.websocket;

import csbase.server.services.restservice.RestService;
import csbase.server.services.restservice.websocket.User;
import org.json.JSONException;
import org.json.JSONObject;

public class Message
extends JSONObject {
    private static final String LOGIN_MESSAGE_KEY = "RestService.websocket.login";
    private static final String LOGOUT_MESSAGE_KEY = "RestService.websocket.logout";
    public static final String TYPE_CHAT_MESSAGE = "text";
    public static final String TYPE_USERLIST_UPDATE = "ulupd";
    public static final String TYPE_PROJECT_CHANGE = "prchg";
    public static final String TYPE_CHAT_HISTORY = "chist";
    public static final String TYPE_NOTIFICATION_HISTORY = "nhist";
    public static final String TYPE_COMMAND_TERMINATE = "cmdtmt";
    private static final String TYPE = "type";
    private static final String USER = "user";
    private static final String CONTENT = "content";
    private static final String TIMESTAMP = "timestamp";

    public Message() {
        this.setTimestamp(System.currentTimeMillis());
    }

    public Message(String jsonString) throws JSONException {
        super(jsonString);
        if (this.has(USER)) {
            this.setUser(new User(this.getJSONObject(USER)));
        }
        if (this.getType().equals(TYPE_CHAT_MESSAGE)) {
            this.setContent(Message.escape(this.getString(CONTENT)));
        }
        this.setTimestamp(System.currentTimeMillis());
    }

    public Boolean isChat() {
        return this.getType().equals(TYPE_CHAT_MESSAGE);
    }

    public Boolean isProjectChange() {
        return this.getType().equals(TYPE_PROJECT_CHANGE);
    }

    public String getType() {
        return this.getString(TYPE);
    }

    public void setType(String type) {
        this.put(TYPE, type);
    }

    public User getUser() {
        return (User)((Object)this.get(USER));
    }

    public void setUser(User user) {
        this.put(USER, (Object)user);
    }

    public Object getContent() {
        return this.opt(CONTENT);
    }

    public void setContent(Object content) {
        this.put(CONTENT, content);
    }

    public long getTimestamp() {
        return this.getLong(TIMESTAMP);
    }

    public void setTimestamp(long timestamp) {
        this.put(TIMESTAMP, timestamp);
    }

    public static String escape(String orig) {
        StringBuilder buffer = new StringBuilder(orig.length());
        block7: for (int i = 0; i < orig.length(); ++i) {
            char c = orig.charAt(i);
            switch (c) {
                case '\n': {
                    buffer.append("<br />");
                    continue block7;
                }
                case '\r': {
                    continue block7;
                }
                case '<': {
                    buffer.append("&lt;");
                    continue block7;
                }
                case '>': {
                    buffer.append("&gt;");
                    continue block7;
                }
                case '&': {
                    buffer.append("&amp;");
                    continue block7;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        return buffer.toString();
    }

    public static class SystemMessage
    extends Message {
        private static final User SYSTEM_USER = new User().setLogin("system");

        public SystemMessage(String chatMessage) {
            this.setType(Message.TYPE_CHAT_MESSAGE);
            this.setUser(SYSTEM_USER);
            this.setContent(chatMessage);
        }

        public static Message login(String username) {
            return new SystemMessage(RestService.getInstance().getFormattedString(Message.LOGIN_MESSAGE_KEY, new Object[]{username}));
        }

        public static Message logout(String username) {
            return new SystemMessage(RestService.getInstance().getFormattedString(Message.LOGOUT_MESSAGE_KEY, new Object[]{username}));
        }
    }
}

