/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.sgaservice.ssl;

import csbase.server.Server;
import csbase.server.services.sgaservice.ssl.SSLContext;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import javax.security.cert.X509Certificate;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.iiop.ServerIIOPConnection;
import org.jacorb.orb.portableInterceptor.ServerRequestInfoImpl;
import org.omg.CORBA.LocalObject;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

public class SSLServerInterceptor
extends LocalObject
implements ServerRequestInterceptor {
    private static final long serialVersionUID = -7115220989115590930L;
    private SSLContext inspector;

    public SSLServerInterceptor(SSLContext contextInspector) {
        this.inspector = contextInspector;
    }

    public void receive_request_service_contexts(ServerRequestInfo ri) throws ForwardRequest {
    }

    public void receive_request(ServerRequestInfo ri) throws ForwardRequest {
        if (!ri.operation().equals("registerSGA")) {
            return;
        }
        GIOPConnection connection = ((ServerRequestInfoImpl)ri).getConnection();
        if (connection == null) {
            return;
        }
        if (!connection.isSSL()) {
            return;
        }
        if (!(connection.getTransport() instanceof ServerIIOPConnection)) {
            return;
        }
        ServerIIOPConnection transport = (ServerIIOPConnection)connection.getTransport();
        SSLSocket sslSocket = (SSLSocket)transport.getSocket();
        try {
            X509Certificate[] certs = sslSocket.getSession().getPeerCertificateChain();
            String dn = certs[0].getSubjectDN().getName();
            LdapName ln = new LdapName(dn);
            String sgaName = null;
            for (Rdn rdn : ln.getRdns()) {
                if (!rdn.getType().equalsIgnoreCase("CN")) continue;
                sgaName = (String)rdn.getValue();
                break;
            }
            this.inspector.setContextInformation(sgaName);
        }
        catch (SSLPeerUnverifiedException e) {
            Server.logSevereMessage("Erro ao obter o certificado de SGA.");
        }
        catch (InvalidNameException e) {
            Server.logSevereMessage("Erro ao obter o CN do certificado.");
        }
    }

    public void send_reply(ServerRequestInfo ri) {
    }

    public void send_exception(ServerRequestInfo ri) throws ForwardRequest {
    }

    public void send_other(ServerRequestInfo ri) throws ForwardRequest {
    }

    public String name() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public void destroy() {
    }
}

