/*
 * Decompiled with CFR 0.152.
 */
package csbase.sga.executor;

import csbase.server.plugin.service.sgaservice.SGADaemonException;
import csbase.sga.SGALocal;
import csbase.sga.executor.DefaultJobData;
import csbase.sga.executor.DirectoryMonitor;
import csbase.sga.executor.JobData;
import csbase.sga.executor.JobExecutor;
import csbase.sga.executor.JobInfo;
import csbase.sga.executor.JobObserver;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sgaidl.ActionNotSupportedException;
import sgaidl.JobControlAction;
import sgaidl.ProcessState;

public class DefaultJobExecutor
implements JobExecutor {
    private String commandTemplate = "/usr/bin/time -p 2> {0} /bin/ksh -c ''{1}; echo $PPID>{2}''";
    private String shellCommand = "/bin/ksh";
    private String shellArgs = "-c";
    private Map<String, Process> processes;
    private Map<String, JobInfo> infos;
    private Map<String, JobObserver> observers;
    private String sandBoxPath = null;
    private Thread eventMonitorThread;
    private Logger logger = Logger.getLogger(SGALocal.class.getName());

    public DefaultJobExecutor(Properties pluginProperties) throws SGADaemonException {
        this.processes = new Hashtable<String, Process>();
        this.infos = new Hashtable<String, JobInfo>();
        this.observers = new Hashtable<String, JobObserver>();
        if (pluginProperties.getProperty("csbase_sandbox_root_directory") == null) {
            throw new SGADaemonException("A propriedade csbase_sandbox_root_directory n\u00e3o foi definida.");
        }
        File sandboxdir = new File(pluginProperties.getProperty("csbase_sandbox_root_directory"));
        if (!sandboxdir.exists()) {
            sandboxdir.mkdir();
        }
        if (!sandboxdir.exists() || !sandboxdir.isDirectory()) {
            throw new SGADaemonException("O diret\u00f3rio defindo na propriedade csbase_sandbox_root_directory n\u00e3o existe ou n\u00e3o \u00e9 diret\u00f3rio.");
        }
        this.sandBoxPath = sandboxdir.getAbsolutePath();
        this.eventMonitorThread = new Thread(new DirectoryMonitor(this.sandBoxPath, this));
        this.eventMonitorThread.setName(this.getClass().getSimpleName() + "::" + "FileSystemMonitorThread");
        this.eventMonitorThread.start();
    }

    @Override
    public synchronized JobData executeJob(String jobCommand, Map<String, String> extraParams, JobObserver observer) {
        String id = DefaultJobExecutor.getId();
        this.logger.info("Executando o job com id " + id);
        try {
            String[] cmd = this.buildJobCommand(id, jobCommand);
            ProcessBuilder builder = new ProcessBuilder(cmd).directory(new File(this.sandBoxPath));
            Map<String, String> env = builder.environment();
            env.put("PATH", env.get("PATH") + ":/usr/local/bin");
            Process p = builder.start();
            JobInfo info = new JobInfo();
            info.jobParam.put("csbase_command_state", ProcessState.RUNNING.toString());
            this.infos.put(id, info);
            this.processes.put(id, p);
            this.observers.put(id, observer);
        }
        catch (IOException ex) {
            // empty catch block
        }
        return new DefaultJobData(id);
    }

    private String[] buildJobCommand(String jobId, String jobCommand) {
        String cmd = MessageFormat.format(this.commandTemplate, DirectoryMonitor.getTimeFile(jobId), jobCommand, DirectoryMonitor.getDoneFile(jobId));
        return new String[]{this.shellCommand, this.shellArgs, cmd};
    }

    private static String getId() {
        return UUID.randomUUID().toString();
    }

    @Override
    public synchronized void controlJob(JobData data, String child, JobControlAction action) throws ActionNotSupportedException {
        String jobId = data.toString();
        this.logger.info("Solicita\u00e7\u00e3o de aplica\u00e7\u00e3o de a\u00e7\u00e3o no job com id " + jobId);
        if (!this.processes.containsKey(jobId)) {
            return;
        }
        if (action.value() != 4) {
            throw new ActionNotSupportedException();
        }
        Process p = this.processes.get(jobId);
        p.destroy();
        this.notifyJobFinished(jobId);
        this.logger.info("T\u00e9rmino do job com id " + jobId);
    }

    @Override
    public synchronized JobInfo getJobInfo(JobData data) {
        return this.makeDefaultJobInfo();
    }

    private JobInfo makeDefaultJobInfo() {
        JobInfo pInfo = new JobInfo();
        pInfo.jobParam.put("csbase_command_state", ProcessState.RUNNING.toString());
        pInfo.jobParam.put("csbase_command_cpu_perc", "0.15");
        pInfo.jobParam.put("csbase_command_memory_ram_size_mb", "4");
        pInfo.jobParam.put("csbase_command_memory_swap_size_mb", "16");
        pInfo.jobParam.put("csbase_command_wall_time_sec", "20");
        pInfo.jobParam.put("csbase_command_virtual_memory_size_mb", "8");
        pInfo.jobParam.put("csbase_command_bytes_in_kb", "2048");
        pInfo.jobParam.put("csbase_command_bytes_out_kb", "1024");
        pInfo.jobParam.put("csbase_command_disk_bytes_write_kb", "512");
        pInfo.jobParam.put("csbase_command_exec_host", "256");
        return pInfo;
    }

    @Override
    public synchronized boolean recoveryJob(JobData data, JobObserver observer) {
        String jobId = data.toString();
        this.logger.info("Recupera\u00e7\u00e3o do job com id " + jobId);
        String doneFile = DirectoryMonitor.getDoneFile(jobId);
        if (!Files.exists(Paths.get(doneFile, new String[0]), new LinkOption[0])) {
            return false;
        }
        this.notifyJobFinished(jobId);
        return true;
    }

    public synchronized void notifyJobFinished(String jobId) {
        this.logger.info("Recebida a notifica\u00e7\u00e3o de t\u00e9rmino do job com id " + jobId);
        if (this.infos.containsKey(jobId)) {
            String timeFile = DirectoryMonitor.getTimeFile(jobId);
            Map<String, String> timeMap = this.getTimes(timeFile);
            JobInfo jobInfo = this.infos.get(jobId);
            jobInfo.jobParam.putAll(timeMap);
            JobObserver observer = this.observers.get(jobId);
            observer.onJobCompleted(jobInfo);
        }
    }

    private Map<String, String> getTimes(String timeFile) {
        Pattern realPattern = Pattern.compile("^real.*?(\\d+)\\.(\\d+)");
        Pattern userPattern = Pattern.compile("^user.*?(\\d+)\\.(\\d+)");
        Pattern sysPattern = Pattern.compile("^sys.*?(\\d+)\\.(\\d+)");
        List<String> lines = null;
        try {
            lines = Files.readAllLines(Paths.get(timeFile, new String[0]), Charset.defaultCharset());
        }
        catch (IOException e) {
            this.logger.severe("Erro ao ler o arquivo de tempos: " + timeFile);
        }
        String wallTime = null;
        String userTim = null;
        String cpuTime = null;
        for (String line : lines) {
            String temp = DefaultJobExecutor.matchTime(line, realPattern);
            if (temp != null) {
                wallTime = temp;
            }
            if ((temp = DefaultJobExecutor.matchTime(line, userPattern)) != null) {
                userTim = temp;
            }
            if ((temp = DefaultJobExecutor.matchTime(line, sysPattern)) == null) continue;
            cpuTime = temp;
        }
        return this.createTimeMap(wallTime, userTim, cpuTime);
    }

    private static String matchTime(String string, Pattern pattern) {
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private Map<String, String> createTimeMap(String wall, String user, String cpu) {
        HashMap<String, String> timeMap = new HashMap<String, String>();
        timeMap.put("csbase_command_wall_time_sec", wall != null ? wall : "-1");
        timeMap.put("csbase_command_user_time_sec", user != null ? user : "-1");
        timeMap.put("csbase_command_time_sec", cpu != null ? cpu : "-1");
        return timeMap;
    }
}

