/**
 * $Id: SGADriver.java 168372 2015-09-18 20:10:22Z fpina $
 */

package csbase.sga.ssh;

import java.util.Map;
import java.util.Properties;

import csbase.sga.executor.JobData;
import csbase.sga.executor.JobInfo;
import csbase.sga.monitor.SGAInfo;

/**
 * @author Tecgraf
 */
public interface SGADriver {
  void init(Properties properties);

  /**
   * Build the command to submit a job in the execution environment.
   *
   * @param script scritp to execute
   * @param extraParam extra parameters to the execution environment
   *
   * @return the command to submit the job
   */
  String buildSubmitJobCommand(String script, Map<String, String> extraParam);

  /**
   * Parse the output of the command to submit a job in the execution
   * environment.
   *
   * @param output the output to parse
   *
   * @return the {@link JobData} representing the job
   */
  JobData parseJobSubmissionOutput(String output);

  /**
   * Build the command to check the information of a job.
   *
   * @param jobData the {@link JobData} representing the job
   *
   * @return the command to check the job
   */
  String buildCheckJobCommand(JobData jobData);

  /**
   * Build the command to check the information of all jobs in the execution
   * environment.
   *
   * @return the command to check all jobs
   */
  String buildCheckAllJobsCommand();

  /**
   * Parse the output of the command to check jobs in the execution environment.
   *
   * @param output the output to parse
   *
   * @return a map with {@link JobData} and the corresponding {@link JobInfo}
   */
  Map<JobData, JobInfo> parseCheckJobOutput(String output);

  /**
   * Build the command to kill a job in the execution environment.
   *
   * @param jobData the {@link JobData} representing the job
   *
   * @return the command to kill the job
   */
  String buildKillJobCommand(JobData jobData);

  String buildCheckEnvironmentCommand();

  SGAInfo parseCheckEnvironmentOutput(String output);
}
