/*
 * Decompiled with CFR 0.152.
 */
package csbase.sga.ssh;

import csbase.sga.monitor.EnvironmentMonitor;
import csbase.sga.monitor.SGAInfo;
import csbase.sga.ssh.SGADriver;
import csbase.sga.ssh.SGASSH;
import csbase.sga.ssh.SSHClientFactory;
import csbase.sshclient.CommandResult;
import csbase.sshclient.SSHClient;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SSHMonitor
implements EnvironmentMonitor {
    private ScheduledExecutorService checkEnvironmentExecutor = Executors.newScheduledThreadPool(1);
    private final Properties pluginProperties;
    private final SGADriver driver;
    private SSHClientFactory sshClientFactory;
    private SGAInfo sgaInfo;
    private Logger logger;
    private long lastJobInfoUpdate = 0L;
    private long checkEnvironmentInterval = 20000L;

    public SSHMonitor(Properties pluginProperties, SGADriver driver, SSHClientFactory sshClientFactory) {
        this.pluginProperties = pluginProperties;
        if (pluginProperties.containsKey("csbase_machine_time_seconds")) {
            this.checkEnvironmentInterval = Long.parseLong(pluginProperties.getProperty("csbase_machine_time_seconds")) * 1000L;
        }
        this.driver = driver;
        this.sshClientFactory = sshClientFactory;
        this.sgaInfo = new SGAInfo(this.pluginProperties);
        String sgaName = pluginProperties.getProperty("csbase_sga_name");
        this.logger = Logger.getLogger(SGASSH.class.getName() + "." + sgaName);
    }

    public synchronized SGAInfo getSGAInfo() {
        this.updateSGAInfo();
        return this.sgaInfo;
    }

    private synchronized void setSGAInfo(SGAInfo sgaInfo) {
        this.sgaInfo = sgaInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSGAInfo() {
        if (System.currentTimeMillis() - this.lastJobInfoUpdate <= this.checkEnvironmentInterval) {
            return;
        }
        SSHClient client = null;
        try {
            client = this.sshClientFactory.getSSHClient();
            String command = this.driver.buildCheckEnvironmentCommand();
            this.logger.fine("Check enviroment command line: " + command);
            CommandResult result = client.execute(command);
            if (result.getStatus() > 0) {
                this.logger.log(Level.WARNING, "Check environment return code: " + result.getStatus() + "\nOutput: " + result.getOutput() + "\nError: " + result.getError());
                return;
            }
            this.logger.fine("Check environment return code: " + result.getStatus() + "\nOutput: " + result.getOutput() + "\nError: " + result.getError());
            this.sgaInfo = this.driver.parseCheckEnvironmentOutput(result.getOutput());
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Erro checking the environment", e);
        }
        finally {
            if (client != null) {
                client.disconnect();
            }
        }
    }

    private class CheckEnvironmentTask
    implements Runnable {
        private CheckEnvironmentTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SSHClient client = null;
            try {
                client = SSHMonitor.this.sshClientFactory.getSSHClient();
                String command = SSHMonitor.this.driver.buildCheckEnvironmentCommand();
                SSHMonitor.this.logger.fine("Check enviroment command line: " + command);
                CommandResult result = client.execute(command);
                if (result.getStatus() > 0) {
                    SSHMonitor.this.logger.log(Level.WARNING, "Check environment return code: " + result.getStatus() + "\nOutput: " + result.getOutput() + "\nError: " + result.getError());
                    return;
                }
                SSHMonitor.this.logger.fine("Check environment return code: " + result.getStatus() + "\nOutput: " + result.getOutput() + "\nError: " + result.getError());
                SSHMonitor.this.setSGAInfo(SSHMonitor.this.driver.parseCheckEnvironmentOutput(result.getOutput()));
            }
            catch (Exception e) {
                SSHMonitor.this.logger.log(Level.SEVERE, "Erro checking the environment", e);
            }
            finally {
                if (client != null) {
                    client.disconnect();
                }
            }
        }
    }
}

