/*
 * Decompiled with CFR 0.152.
 */
package csbase.sga.ssh.sge;

import csbase.sga.executor.JobData;
import csbase.sga.executor.JobInfo;
import csbase.sga.monitor.SGAInfo;
import csbase.sga.ssh.SGADriver;
import csbase.sga.ssh.sge.SGEJobData;
import csbase.sga.ssh.sge.xml.SGESAXReader;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sgaidl.ProcessState;

public class SGEDriver
implements SGADriver {
    private static final String QUEUE_KEY = "sga_sge_queue";
    private static final String TIME_KEY = "sga_sge_time";
    private static final String MEMORY_KEY = "sga_sge_memory";
    private static final String NODES_KEY = "sga_sge_nodes";
    private static final String PROCESSES_KEY = "sga_sge_processes";
    private static final String PPN_KEY = "sga_sge_ppn";
    private static final String TPP_KEY = "sga_sge_tpp";
    private static final String MPI_NP_KEY = "sga_sge_mpi_np";
    private static final String OPENMP_NP_KEY = "sga_sge_openmp_np";
    private static final String PE_KEY = "sga_sge_pe";
    private static final String DEFAULT_PE_KEY = "sga_sge_default_pe";
    private static final String PE_NP_KEY = "sga_sge_pe_np";
    private static final String PE_NT_KEY = "sga_sge_pe_nt";
    private static final String QUEUE_ARG = " -q ";
    private static final String TIME_ARG = " -l h_rt=";
    private static final String MEMORY_ARG = " -l h_vmem=";
    private static final String NODES_ARG = " -l nodes=";
    private static final String PROCESSES_ARG = " -l np=";
    private static final String PPN_ARG = ",ppn=";
    private static final String TPP_ARG = ",tpp=";
    private static final String MPI_NP_ARG = " -pe ib ";
    private static final String OPENMP_NP_ARG = " -pe smp ";
    private static final String PE_ARG = " -pe ";
    private static final String SUBMIT_JOB = "qsub -j yes {0} {1}";
    private static final String CHECK_JOB = "qstat -s prsz -ext -xml -j {0}";
    private static final String CHECK_ALL_JOBS = "qstat -s prsz -ext -xml";
    private static final String KILL_JOB = "qdel -f {0}";
    private static final String CHECK_ENVIRONMENT = "qhost -F -q -xml";
    private Pattern JOB_ID_PATTERN = Pattern.compile("Your job (\\d+) \\(\".+\"\\) has been submitted\n");
    private Properties properties;

    @Override
    public void init(Properties properties) {
        this.properties = properties;
    }

    @Override
    public String buildSubmitJobCommand(String script, Map<String, String> extraParam) {
        String peArg;
        StringBuilder resourceList;
        block19: {
            String nodeArg;
            resourceList = new StringBuilder();
            if (this.properties.containsKey(QUEUE_KEY)) {
                resourceList.append(QUEUE_ARG + this.properties.get(QUEUE_KEY));
            }
            if (extraParam.containsKey(TIME_KEY)) {
                resourceList.append(TIME_ARG + extraParam.get(TIME_KEY));
            }
            if (extraParam.containsKey(MEMORY_KEY)) {
                resourceList.append(MEMORY_ARG + extraParam.get(MEMORY_KEY));
            }
            if (extraParam.containsKey(NODES_KEY)) {
                nodeArg = NODES_ARG + extraParam.get(NODES_KEY);
                if (extraParam.containsKey(PPN_KEY)) {
                    nodeArg = nodeArg.concat(PPN_ARG + extraParam.get(PPN_KEY));
                }
                if (extraParam.containsKey(TPP_KEY)) {
                    nodeArg = nodeArg.concat(TPP_ARG + extraParam.get(TPP_KEY));
                }
                resourceList.append(nodeArg);
            }
            if (extraParam.containsKey(PROCESSES_KEY)) {
                nodeArg = PROCESSES_ARG + extraParam.get(PROCESSES_KEY);
                if (extraParam.containsKey(PPN_KEY)) {
                    nodeArg = nodeArg.concat(PPN_ARG + extraParam.get(PPN_KEY));
                }
                if (extraParam.containsKey(TPP_KEY)) {
                    nodeArg = nodeArg.concat(TPP_ARG + extraParam.get(TPP_KEY));
                }
                resourceList.append(nodeArg);
            }
            if (extraParam.containsKey(MPI_NP_KEY)) {
                resourceList.append(MPI_NP_ARG + extraParam.get(MPI_NP_KEY));
            }
            if (extraParam.containsKey(OPENMP_NP_KEY)) {
                resourceList.append(OPENMP_NP_ARG + extraParam.get(OPENMP_NP_KEY));
            }
            peArg = "";
            try {
                if (!extraParam.containsKey(PE_NP_KEY)) break block19;
                int np = Integer.parseInt(extraParam.get(PE_NP_KEY));
                if (extraParam.containsKey(PE_KEY)) {
                    if (extraParam.containsKey(PE_NT_KEY)) {
                        int nt = Integer.parseInt(extraParam.get(PE_NT_KEY));
                        peArg = PE_ARG + extraParam.get(PE_KEY) + "t" + nt + " " + np * nt;
                    } else {
                        peArg = PE_ARG + extraParam.get(PE_KEY) + " " + np;
                    }
                    break block19;
                }
                if (this.properties.containsKey(DEFAULT_PE_KEY)) {
                    if (extraParam.containsKey(PE_NT_KEY)) {
                        int nt = Integer.parseInt(extraParam.get(PE_NT_KEY));
                        peArg = PE_ARG + this.properties.get(DEFAULT_PE_KEY) + "t" + nt + " " + np * nt;
                    } else {
                        peArg = PE_ARG + this.properties.get(DEFAULT_PE_KEY) + " " + np;
                    }
                    break block19;
                }
                throw new Exception();
            }
            catch (Exception e) {
                peArg = "";
            }
        }
        resourceList.append(peArg);
        String[] splitedScript = script.split("\\s");
        return MessageFormat.format(SUBMIT_JOB, resourceList.toString(), splitedScript[1]);
    }

    @Override
    public String buildKillJobCommand(JobData jobData) {
        SGEJobData data = (SGEJobData)jobData;
        return MessageFormat.format(KILL_JOB, data.getJobId());
    }

    @Override
    public String buildCheckJobCommand(JobData jobData) {
        SGEJobData data = (SGEJobData)jobData;
        return MessageFormat.format(CHECK_JOB, data.getJobId());
    }

    @Override
    public String buildCheckAllJobsCommand() {
        return CHECK_ALL_JOBS;
    }

    @Override
    public JobData parseJobSubmissionOutput(String output) {
        Matcher matcher = this.JOB_ID_PATTERN.matcher(output);
        if (matcher.matches()) {
            return new SGEJobData(matcher.group(1));
        }
        return null;
    }

    @Override
    public Map<JobData, JobInfo> parseCheckJobOutput(String output) {
        HashMap<JobData, JobInfo> jobsInfo = new HashMap<JobData, JobInfo>();
        List<Map<String, String>> jobList = new SGESAXReader().parseCommands(output);
        for (Map<String, String> jobMap : jobList) {
            jobsInfo.put(new SGEJobData(jobMap.get("JB_job_number")), this.convertToJobInfo(jobMap));
        }
        return jobsInfo;
    }

    private JobInfo convertToJobInfo(Map<String, String> jobMap) {
        ProcessState jobState;
        JobInfo jobInfo = new JobInfo();
        jobInfo.jobParam.put("csbase_command_pid", jobMap.get("JB_job_number"));
        switch (jobMap.get("state")) {
            case "pending": {
                jobState = ProcessState.WAITING;
                break;
            }
            case "running": {
                jobState = ProcessState.RUNNING;
                break;
            }
            case "zombie": {
                jobState = ProcessState.FINISHED;
                break;
            }
            default: {
                jobState = ProcessState.WAITING;
            }
        }
        jobInfo.jobParam.put("csbase_command_state", jobState.toString());
        String host = jobMap.get("host");
        jobInfo.jobParam.put("csbase_command_exec_host", host == null ? "" : host);
        return jobInfo;
    }

    @Override
    public String buildCheckEnvironmentCommand() {
        return CHECK_ENVIRONMENT;
    }

    @Override
    public SGAInfo parseCheckEnvironmentOutput(String output) {
        SGAInfo info = new SGAInfo(this.properties);
        List<Map<String, String>> nodesList = new SGESAXReader().parseNodes(output);
        for (Map<String, String> nodeMap : nodesList) {
            if (this.properties.containsKey(QUEUE_KEY) && !nodeMap.get("queues").contains(this.properties.getProperty(QUEUE_KEY))) continue;
            String freeRamPerc = this.calcPercFree(nodeMap.get("mem_total"), nodeMap.get("mem_used"));
            String freeSwapPerc = this.calcPercFree(nodeMap.get("swap_total"), nodeMap.get("swap_used"));
            info.addNode(nodeMap.get("name"), null, nodeMap.get("num_proc"), null, this.expandUnit(nodeMap.get("mem_total")), this.expandUnit(nodeMap.get("swap_total")), freeRamPerc, freeSwapPerc, nodeMap.get("np_load_short"), nodeMap.get("np_load_medium"), nodeMap.get("np_load_long"), nodeMap.get("total_slots_used"));
        }
        return info;
    }

    private String calcPercFree(String total, String used) {
        String eTotal = this.expandUnit(total);
        String eUsed = this.expandUnit(used);
        if (eTotal == null || eUsed == null) {
            return null;
        }
        Double t = Double.parseDouble(eTotal);
        Double u = Double.parseDouble(eUsed);
        Double perc = (t - u) / t;
        if (Double.isNaN(perc)) {
            return null;
        }
        return String.valueOf(perc);
    }

    private String expandUnit(String number) {
        try {
            if (number.endsWith("M")) {
                return String.valueOf(Double.parseDouble(number.substring(0, number.length() - 2)));
            }
            if (number.endsWith("G")) {
                return String.valueOf(Double.parseDouble(number.substring(0, number.length() - 2)) * 1024.0);
            }
            return String.valueOf(Double.parseDouble(number));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

