/**
 * $Id: SGEJobData.java 167543 2015-08-18 15:47:17Z fpina $
 */
package csbase.sga.ssh.sge;

import csbase.sga.executor.JobData;
import csbase.sga.ssh.AbstractSSHJobData;

/**
 * Implements the interface {@link JobData} to the SGE execution environment.
 *
 * @author Tecgraf/PUC-Rio
 */
public class SGEJobData extends AbstractSSHJobData {
  private String jobId;

  /**
   * Constructor.
   *
   * @param jobId the job's id
   */
  public SGEJobData(String jobId) {
    this.jobId = jobId;
  }

  /**
   * Get the job's id.
   *
   * @return the job's id
   */
  public String getJobId() {
    return this.jobId;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean equals(Object object) {
    return this.getJobId().equals(this.getClass().cast(object).getJobId());
  }

  @Override
  public int hashCode() {
    return jobId.hashCode();
  }

  @Override
  public String toString() {
    return this.jobId;
  }
}
