/*
 * Decompiled with CFR 0.152.
 */
package csbase.sga;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import csbase.server.plugin.service.sgaservice.SGADaemonCommand;
import csbase.sga.executor.JobData;
import csbase.sga.executor.JobExecutor;
import csbase.sga.executor.JobInfo;
import csbase.sga.executor.JobObserver;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import sgaidl.ActionNotSupportedException;
import sgaidl.InvalidActionException;
import sgaidl.InvalidTransitionException;
import sgaidl.JobControlAction;
import sgaidl.Pair;
import sgaidl.ProcessState;
import sgaidl.RunningCommandInfo;

public class SGALocalCommand
extends SGADaemonCommand {
    private static final long serialVersionUID = -5874016392438461849L;
    private static Executor notifier = Executors.newCachedThreadPool();
    private Logger logger;
    private JobExecutor executor;
    private String commandId;
    private JobData jobData;
    private ListenableFuture<JobData> jobDataFuture;
    private ListenableFuture<Boolean> recoveryStatusFuture;
    private JobObserver observer;

    protected void setLogger(Logger logger) {
        this.logger = logger;
    }

    protected SGALocalCommand(JobExecutor executor, String commandId) {
        this.executor = executor;
        this.commandId = commandId;
    }

    protected SGALocalCommand(JobExecutor executor, String commandId, JobData jobData) {
        this.executor = executor;
        this.commandId = commandId;
        this.jobData = jobData;
    }

    protected JobData getJobData() {
        if (this.jobData != null) {
            return this.jobData;
        }
        if (this.jobDataFuture.isDone()) {
            try {
                return (JobData)this.jobDataFuture.get();
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    protected JobExecutor getExecutor() {
        return this.executor;
    }

    protected void execute(final String commandString, final Map<String, String> execParam, final JobObserver observer) {
        this.observer = observer;
        final ListeningExecutorService commandExecutor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newSingleThreadExecutor());
        this.jobDataFuture = commandExecutor.submit((Callable)new Callable<JobData>(){

            @Override
            public JobData call() throws Exception {
                try {
                    SGALocalCommand.this.logger.log(Level.INFO, "Submitting command {0} to executor", new Object[]{SGALocalCommand.this.commandId});
                    return SGALocalCommand.this.executor.executeJob(commandString, execParam, observer);
                }
                catch (CancellationException e) {
                    throw e;
                }
                catch (Exception e) {
                    SGALocalCommand.this.logger.log(Level.SEVERE, "Error while executing command " + SGALocalCommand.this.commandId, e);
                    return null;
                }
            }
        });
        Futures.addCallback(this.jobDataFuture, (FutureCallback)new FutureCallback<JobData>(){

            public void onSuccess(JobData data) {
                if (data == null) {
                    SGALocalCommand.this.logger.log(Level.WARNING, "Command {0} not initialized", new Object[]{SGALocalCommand.this.commandId});
                    observer.onJobLost();
                } else {
                    observer.onJobStarted(data);
                }
                commandExecutor.shutdown();
            }

            public void onFailure(Throwable t) {
                if (CancellationException.class.isInstance(t)) {
                    SGALocalCommand.this.logger.log(Level.FINE, "Canceling the execution of command {0}", new Object[]{SGALocalCommand.this.commandId});
                } else {
                    SGALocalCommand.this.logger.log(Level.SEVERE, "Error while executing command: " + SGALocalCommand.this.commandId, t);
                }
                observer.onJobLost();
                commandExecutor.shutdown();
            }
        });
    }

    protected void recovery(JobData data, final JobObserver observer) {
        this.jobData = data;
        this.observer = observer;
        final ListeningExecutorService commandExecutor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newSingleThreadExecutor());
        this.recoveryStatusFuture = commandExecutor.submit((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                SGALocalCommand.this.logger.log(Level.INFO, "Recovering command {0} from executor", new Object[]{SGALocalCommand.this.commandId});
                return SGALocalCommand.this.executor.recoveryJob(SGALocalCommand.this.jobData, observer);
            }
        });
        Futures.addCallback(this.recoveryStatusFuture, (FutureCallback)new FutureCallback<Boolean>(){

            public void onSuccess(Boolean wasRecovered) {
                if (!wasRecovered.booleanValue()) {
                    SGALocalCommand.this.logger.log(Level.INFO, "Command {0} not recovered", new Object[]{SGALocalCommand.this.commandId});
                    observer.onJobLost();
                }
                commandExecutor.shutdown();
            }

            public void onFailure(Throwable t) {
                SGALocalCommand.this.logger.log(Level.SEVERE, "Error while recovering command: " + SGALocalCommand.this.commandId, t);
                observer.onJobLost();
                commandExecutor.shutdown();
            }
        });
    }

    public void control(JobControlAction action, String child) throws InvalidActionException, ActionNotSupportedException, InvalidTransitionException {
        this.logger.log(Level.INFO, "Sending action {0} to command {1}", new Object[]{action.toString(), this.commandId});
        JobData data = this.getJobData();
        if (data != null) {
            this.executor.controlJob(data, child, action);
        } else if (!this.jobDataFuture.cancel(true)) {
            this.logger.log(Level.WARNING, "Error while canceling command {0}", new Object[]{this.commandId});
        }
    }

    public RunningCommandInfo getRunningCommandInfo() {
        this.logger.log(Level.INFO, "Getting info from command {0}", new Object[]{this.commandId});
        JobData data = this.getJobData();
        if (data == null) {
            return this.convertJobInfoToRunningCommandInfo(new JobInfo());
        }
        final JobInfo info = this.executor.getJobInfo(data);
        if (info == null) {
            this.logger.log(Level.FINE, "Error while getting info from command {0}", new Object[]{this.commandId});
            return null;
        }
        if (info.jobParam.get("csbase_command_state").equals(ProcessState.FINISHED.toString())) {
            notifier.execute(new Runnable(){

                @Override
                public void run() {
                    long startTime = System.currentTimeMillis();
                    SGALocalCommand.this.observer.onJobCompleted(info);
                    SGALocalCommand.this.logger.fine("Time took to notify command completion: " + (System.currentTimeMillis() - startTime) + " ms");
                }
            });
        }
        return this.convertJobInfoToRunningCommandInfo(info);
    }

    private RunningCommandInfo makeBlankInfo() {
        return new RunningCommandInfo((Pair[][])new Pair[0][], new Pair[0]);
    }

    private RunningCommandInfo makeWatingInfo() {
        Pair[] processInfo = new Pair[]{new Pair("csbase_command_state", ProcessState.WAITING.toString())};
        return new RunningCommandInfo((Pair[][])new Pair[][]{processInfo}, new Pair[0]);
    }

    private RunningCommandInfo convertJobInfoToRunningCommandInfo(JobInfo jobInfo) {
        LinkedList<Pair[]> processData = new LinkedList<Pair[]>();
        LinkedList<Pair> mainProcessDic = new LinkedList<Pair>();
        for (String key : jobInfo.jobParam.keySet()) {
            mainProcessDic.add(new Pair(key, jobInfo.jobParam.get(key)));
        }
        processData.add(mainProcessDic.toArray(new Pair[mainProcessDic.size()]));
        for (JobInfo pInfo : jobInfo.children) {
            LinkedList<Pair> pDic = new LinkedList<Pair>();
            for (String key : pInfo.jobParam.keySet()) {
                pDic.add(new Pair(key, pInfo.jobParam.get(key)));
            }
            processData.add(pDic.toArray(new Pair[pDic.size()]));
        }
        return new RunningCommandInfo((Pair[][])processData.toArray((T[])new Pair[processData.size()][]), new Pair[0]);
    }
}

