package csbase.sga.ssh;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/**
 * $Id: JobStorage.java 169762 2015-11-13 12:37:30Z fpina $
 */

import csbase.sga.executor.JobData;
import csbase.sga.executor.JobInfo;
import csbase.sga.executor.JobObserver;
import sgaidl.COMMAND_STATE;
import sgaidl.ProcessState;

/**
 * @author Tecgraf
 */
public class JobStorage {
  private long jobInfoMaxAge = 60 * 1000;
  private long lastJobInfoUpdate = 0;
  private Map<JobData, JobInfo> jobInfoMap = new Hashtable<>();
  private Map<JobData, JobObserver> jobObserverMap = new Hashtable<>();

  public JobStorage() {
    new JobStorage(jobInfoMaxAge);
  }

  public JobStorage(long jobInfoMaxAge) {
    this.jobInfoMaxAge = jobInfoMaxAge;
  }

  public synchronized void addJob(JobData data, JobObserver observer) {
    jobObserverMap.put(data, observer);
    jobInfoMap.put(data, new JobInfo());
  }

  public synchronized boolean addObserver(JobData data, JobObserver observer) {
    if (jobInfoMap.containsKey(data)) {
      jobObserverMap.put(data, observer);
      return true;
    }
    else {
      return false;
    }
  }

  public synchronized JobInfo getJobInfo(JobData data) {
    if (jobInfoMap.containsKey(data)) {
      return jobInfoMap.get(data);
    }
    else {
      return null;
    }
  }

  public synchronized Set<JobData> getJobs() {
    Set jobs = new HashSet<>();
    jobs.addAll(jobObserverMap.keySet());
    jobs.addAll(jobInfoMap.keySet());
    return jobs;
  }

  public synchronized void updateJobs(Map<JobData, JobInfo> jobsInfo) {
    jobInfoMap.putAll(jobsInfo);
    lastJobInfoUpdate = System.currentTimeMillis();
  }

  public synchronized Map<JobObserver, JobInfo> getFinishedJobs() {
    Map<JobObserver, JobInfo> finishedJobs = new HashMap<>();
    Iterator<Map.Entry<JobData, JobObserver>> it =
      jobObserverMap.entrySet().iterator();
    while (it.hasNext()) {
      Map.Entry<JobData, JobObserver> entry = it.next();
      JobData data = entry.getKey();
      JobObserver observer = entry.getValue();
      if (jobInfoMap.containsKey(data)) {
        JobInfo info = jobInfoMap.get(data);
        if (info.jobParam.get(COMMAND_STATE.value).equals(
          ProcessState.FINISHED.toString())) {
          finishedJobs.put(observer, info);
          it.remove();
        }
      }
    }
    return finishedJobs;
  }

  //  public synchronized Map<JobObserver, JobInfo> getFinishedJobs() {
  //      Map<JobObserver, JobInfo> finishedJobs = new HashMap<>();
  //      for (JobData data : jobObserverMap.keySet()) {
  //        JobObserver observer = jobObserverMap.get(data);
  //        JobInfo info = jobInfoMap.get(data);
  //        if (info.jobParam.get(COMMAND_STATE.value).equals(
  //            ProcessState.FINISHED.toString())) {
  //          finishedJobs.put(observer, info);
  //          jobObserverMap.remove(data);
  //        }
  //      }
  //
  //      return finishedJobs;
  //  }

  public synchronized boolean needsUpdate() {
    return System.currentTimeMillis() - lastJobInfoUpdate > jobInfoMaxAge;
  }
}
