/**
 * $Id: PBSJobData.java 167543 2015-08-18 15:47:17Z fpina $
 */
package csbase.sga.ssh.pbs;

import java.util.Hashtable;
import java.util.Map;

import csbase.sga.executor.JobData;
import csbase.sga.ssh.AbstractSSHJobData;

/**
 * @author Tecgraf/PUC-Rio
 */
public class PBSJobData extends AbstractSSHJobData {
  private String jobId;

  public PBSJobData(String jobId) {
    this.jobId = jobId;
  }

  public String getJobId() {
    return this.jobId;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean equals(Object object) {
    return this.getJobId().equals(this.getClass().cast(object).getJobId());
  }

  @Override
  public int hashCode() {
    return jobId.hashCode();
  }

  @Override
  public String toString() {
    return this.jobId;
  }

  public static void main(String[] args) {
    Map<JobData, String> map = new Hashtable();
    map.put(new PBSJobData("1"), "1");
    map.put(new PBSJobData("1"), "1");
    map.put(new PBSJobData("2"), "2");
    map.put(new PBSJobData("1"), "1");
    map.put(new PBSJobData("2"), "2");
    map.put(new PBSJobData("3"), "3");

    for (JobData data : map.keySet()) {
      System.out.println(((PBSJobData) data).getJobId() + " " + map.get(data));
    }

  }
}
