/*
 * Decompiled with CFR 0.152.
 */
package csbase.sga.ssh;

import csbase.sga.executor.JobData;
import csbase.sga.executor.JobInfo;
import csbase.sga.executor.JobObserver;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

public class JobStorage {
    private long jobInfoMaxAge = 60000L;
    private long lastJobInfoUpdate = 0L;
    private Map<JobData, JobInfo> jobInfoMap = new Hashtable<JobData, JobInfo>();
    private Map<JobData, JobObserver> jobObserverMap = new Hashtable<JobData, JobObserver>();

    public JobStorage() {
        new JobStorage(this.jobInfoMaxAge);
    }

    public JobStorage(long jobInfoMaxAge) {
        this.jobInfoMaxAge = jobInfoMaxAge;
    }

    public synchronized void addJob(JobData data, JobObserver observer) {
        this.jobObserverMap.put(data, observer);
        this.jobInfoMap.put(data, new JobInfo());
    }

    public synchronized boolean recoverJob(JobData data, JobObserver observer) {
        if (this.jobInfoMap.containsKey(data)) {
            this.jobObserverMap.put(data, observer);
            return true;
        }
        return false;
    }

    public synchronized JobObserver getObserver(JobData data) {
        return this.jobObserverMap.get(data);
    }

    public synchronized void removeJob(JobData data) {
        this.jobInfoMap.remove(data);
        this.jobObserverMap.remove(data);
    }

    public synchronized JobInfo getJobInfo(JobData data) {
        if (this.jobInfoMap.containsKey(data)) {
            return this.jobInfoMap.get(data);
        }
        return null;
    }

    public synchronized Set<JobData> getJobs() {
        HashSet<JobData> jobs = new HashSet<JobData>();
        jobs.addAll(this.jobObserverMap.keySet());
        jobs.addAll(this.jobInfoMap.keySet());
        return jobs;
    }

    public synchronized void updateJobs(Map<JobData, JobInfo> jobsInfo) {
        this.jobInfoMap.putAll(jobsInfo);
        this.lastJobInfoUpdate = System.currentTimeMillis();
    }

    public synchronized boolean needsUpdate() {
        return System.currentTimeMillis() - this.lastJobInfoUpdate > this.jobInfoMaxAge;
    }
}

