/*
 * Decompiled with CFR 0.152.
 */
package csbase.sga.ssh.pbs.lncc;

import csbase.sga.executor.JobData;
import csbase.sga.executor.JobInfo;
import csbase.sga.monitor.SGAInfo;
import csbase.sga.ssh.SGADriver;
import csbase.sga.ssh.pbs.lncc.PBSJobData;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Parser;
import org.jsoup.select.Elements;
import sgaidl.ProcessState;

public class PBSDriver
implements SGADriver {
    private static final String QUEUE_KEY = "sga_pbs_queue";
    private static final String RESOURCE_LIST = "sga_pbs_resource_list";
    private static final String ENVIRONMENT_CMD = "sga_pbs_environment_cmd";
    private static final String SUBMIT_JOB = "qsub {0} {1}";
    private static final String CHECK_JOB = "qstat -x {0} 2>/dev/null;echo -n \"{1}\";tracejob -v {2} 2>/dev/null";
    private static final String KILL_JOB = "qdel {0}";
    private static final String CHECK_ALL_NODES_XML = "pbsnodes -x";
    private static final Pattern TRACEJOB_JOB_PROPERTIES_PATTERN = Pattern.compile("\\s{1}([^\\s]+)=([^\\s]+)\\s{1}");
    private static final Pattern TRACEJOB_JOB_ID_PATTERN = Pattern.compile("Job: (\\d+)");
    private static final String CHECK_JOB_CMD_SEPARATOR = "%%";
    private static final String CHECK_LIST_JOB_CMD_SEPARATOR = "!!";
    private Properties properties;

    @Override
    public void init(Properties properties) {
        this.properties = properties;
    }

    private String configureEnvironment() {
        if (this.properties.containsKey(ENVIRONMENT_CMD)) {
            return this.properties.getProperty(ENVIRONMENT_CMD) + ";";
        }
        return "";
    }

    @Override
    public String buildSubmitJobCommand(String script, Map<String, String> extraParam) {
        String cmd = this.configureEnvironment() + SUBMIT_JOB;
        String extra = "";
        if (this.properties.containsKey(QUEUE_KEY)) {
            extra = extra + " -q " + this.properties.get(QUEUE_KEY);
        }
        if (this.properties.contains(RESOURCE_LIST)) {
            extra = extra + " -l " + this.properties.get(RESOURCE_LIST);
        }
        String[] splitedScript = script.split("\\s");
        return MessageFormat.format(cmd, extra, splitedScript[1]);
    }

    @Override
    public JobData parseJobSubmissionOutput(String output) {
        if (output != null && !output.isEmpty()) {
            if (output.contains(".")) {
                output = output.substring(0, output.indexOf("."));
            }
            return new PBSJobData(output);
        }
        return null;
    }

    @Override
    public String buildKillJobCommand(JobData jobData) {
        String cmd = this.configureEnvironment() + KILL_JOB;
        PBSJobData data = (PBSJobData)jobData;
        return MessageFormat.format(cmd, data.getJobId());
    }

    @Override
    public String buildCheckJobCommand(JobData jobData) {
        String cmd = this.configureEnvironment() + CHECK_JOB;
        PBSJobData data = (PBSJobData)jobData;
        return MessageFormat.format(cmd, data.getJobId(), CHECK_JOB_CMD_SEPARATOR, data.getJobId());
    }

    @Override
    public JobInfo parseCheckJobOutput(JobData jobData, String output) {
        String[] data = output.split(CHECK_JOB_CMD_SEPARATOR);
        String qstat = data[0].trim();
        String tracejob = data[1].trim();
        JobInfo jobInfo = new JobInfo();
        if (!qstat.isEmpty()) {
            Document doc = Jsoup.parse((String)qstat, (String)"", (Parser)Parser.xmlParser());
            Elements elements = doc.select("data").select("job").select("Job_Id");
            if (elements.size() == 1) {
                String jobId = ((Element)elements.get(0)).text();
                if (jobId.contains(".")) {
                    jobId = jobId.substring(0, jobId.indexOf("."));
                }
                jobInfo.jobParam.put("csbase_command_pid", jobId);
            }
            if ((elements = doc.select("data").select("job").select("exec_host")).size() == 1) {
                String execHost = ((Element)elements.get(0)).text();
                jobInfo.jobParam.put("csbase_command_exec_host", execHost);
            }
            if ((elements = doc.select("data").select("job").select("job_state")).size() == 1) {
                String jobState = ((Element)elements.get(0)).text();
                ProcessState state = PBSDriver.convertJobState(jobState);
                jobInfo.jobParam.put("csbase_command_state", String.valueOf(state));
            }
            elements = doc.select("data").select("job").select("resources_used");
            long ram = -1L;
            long swap = -1L;
            long ctime = -1L;
            long walltime = -1L;
            if (elements.size() == 1) {
                String str;
                Element e = (Element)elements.get(0);
                Elements info = e.select("mem");
                if (info.size() == 1) {
                    str = info.text();
                    ram = this.getInfoInMb(str);
                }
                if ((info = e.select("vmem")).size() == 1) {
                    str = info.text();
                    swap = this.getInfoInMb(str);
                }
                if ((info = e.select("cput")).size() == 1) {
                    str = info.text();
                    ctime = this.getInfoInSec(str);
                }
                if ((info = e.select("walltime")).size() == 1) {
                    str = info.text();
                    walltime = this.getInfoInSec(str);
                }
            }
            jobInfo.jobParam.put("csbase_command_memory_ram_size_mb", Long.toString(ram));
            jobInfo.jobParam.put("csbase_command_memory_swap_size_mb", Long.toString(swap));
            jobInfo.jobParam.put("csbase_command_time_sec", Long.toString(ctime));
            jobInfo.jobParam.put("csbase_command_wall_time_sec", Long.toString(walltime));
        } else if (!tracejob.isEmpty()) {
            String jobId = "";
            Matcher jobIdMatcher = TRACEJOB_JOB_ID_PATTERN.matcher(tracejob);
            if (jobIdMatcher.find()) {
                jobId = jobIdMatcher.group(1);
            }
            if (jobId != null && !jobId.isEmpty()) {
                Matcher matcher = TRACEJOB_JOB_PROPERTIES_PATTERN.matcher(tracejob);
                int start = 0;
                HashMap<String, String> properties = new HashMap<String, String>();
                while (matcher.find(start)) {
                    String key = matcher.group(1);
                    String value = matcher.group(2);
                    properties.put(key, value);
                    start = matcher.start() + 1;
                }
                jobInfo.jobParam.put("csbase_command_pid", jobId);
                jobInfo.jobParam.put("csbase_command_state", String.valueOf(ProcessState.FINISHED));
                String host = (String)properties.get("exec_host");
                jobInfo.jobParam.put("csbase_command_exec_host", host == null ? "" : host);
                String ctimeS = (String)properties.get("resources_used.cput");
                String ramS = (String)properties.get("resources_used.mem");
                String swapS = (String)properties.get("resources_used.vmem");
                String walltimeS = (String)properties.get("resources_used.walltime");
                long ram = ramS != null ? this.getInfoInMb(ramS) : -1L;
                long swap = swapS != null ? this.getInfoInMb(swapS) : -1L;
                long ctime = ctimeS != null ? Long.parseLong(ctimeS) : -1L;
                long walltime = walltimeS != null ? Long.parseLong(walltimeS) : -1L;
                jobInfo.jobParam.put("csbase_command_memory_ram_size_mb", Long.toString(ram));
                jobInfo.jobParam.put("csbase_command_memory_swap_size_mb", Long.toString(swap));
                jobInfo.jobParam.put("csbase_command_time_sec", Long.toString(ctime));
                jobInfo.jobParam.put("csbase_command_wall_time_sec", Long.toString(walltime));
            }
        } else {
            if (jobData != null) {
                jobInfo.jobParam.put("csbase_command_pid", ((PBSJobData)jobData).getJobId());
            }
            jobInfo.jobParam.put("csbase_command_state", String.valueOf(ProcessState.FINISHED));
        }
        return jobInfo;
    }

    private static ProcessState convertJobState(String state) {
        switch (state) {
            case "C": {
                return ProcessState.FINISHED;
            }
            case "E": {
                return ProcessState.FINISHED;
            }
            case "H": {
                return ProcessState.SLEEPING;
            }
            case "Q": {
                return ProcessState.WAITING;
            }
            case "R": {
                return ProcessState.RUNNING;
            }
            case "T": {
                return ProcessState.RUNNING;
            }
            case "W": {
                return ProcessState.SLEEPING;
            }
            case "S": {
                return ProcessState.FINISHED;
            }
        }
        return ProcessState.WAITING;
    }

    @Override
    public String buildCheckJobListCommand(JobData[] jobDataList) {
        return null;
    }

    @Override
    public Map<JobData, JobInfo> parseCheckJobListOutput(JobData[] jobDataList, String output) {
        return null;
    }

    @Override
    public String buildCheckEnvironmentCommand() {
        String cmd = this.configureEnvironment() + CHECK_ALL_NODES_XML;
        if (this.properties.containsKey(QUEUE_KEY)) {
            cmd = cmd + " :" + this.properties.get(QUEUE_KEY);
        }
        return cmd;
    }

    @Override
    public SGAInfo parseCheckEnvironmentOutput(String output) {
        SGAInfo sga = new SGAInfo(this.properties);
        Document doc = Jsoup.parse((String)output, (String)"", (Parser)Parser.xmlParser());
        Elements elements = doc.select("data").select("node");
        for (int i = 0; i < elements.size(); ++i) {
            Element e = (Element)elements.get(i);
            String name = null;
            String ncpus = null;
            long ramMem = -1L;
            long swapMem = -1L;
            long availableRam = -1L;
            long availableSwap = -1L;
            double freeRamPerc = -1.0;
            double freeSwapPerc = -1.0;
            String loadave = null;
            int njobs = 0;
            Elements element = e.select("name");
            if (element.size() == 1) {
                name = ((Element)element.get(0)).text();
            }
            if ((element = e.select("status")).size() == 1) {
                long physmemkb;
                HashMap<String, String> map = new HashMap<String, String>();
                String text = ((Element)element.get(0)).text();
                Pattern NODES_ATTRIBUTES_PATTERN = Pattern.compile("([^,=]+)=([^,]+)");
                Matcher attrsMatcher = NODES_ATTRIBUTES_PATTERN.matcher(text);
                while (attrsMatcher.find()) {
                    map.put(attrsMatcher.group(1), attrsMatcher.group(2));
                }
                ncpus = (String)map.get("ncpus");
                ramMem = physmemkb = this.getInfoInMb((String)map.get("physmem"));
                long totmemkb = this.getInfoInMb((String)map.get("totmem"));
                swapMem = totmemkb - physmemkb;
                long availmemkb = this.getInfoInMb((String)map.get("availmem"));
                availableRam = availmemkb >= swapMem ? availmemkb - swapMem : 0L;
                availableSwap = availmemkb - availableRam;
                freeRamPerc = availableRam * 100L / ramMem;
                freeSwapPerc = availableSwap * 100L / swapMem;
                loadave = (String)map.get("loadave");
                Pattern JOB_IDS_PATTERN = Pattern.compile("([^,]+)");
                if (map.containsKey("jobs")) {
                    Matcher jobsMatcher = JOB_IDS_PATTERN.matcher((CharSequence)map.get("jobs"));
                    while (jobsMatcher.find()) {
                        ++njobs;
                    }
                }
            }
            sga.addNode(name, null, ncpus, "0", Long.toString(ramMem), Long.toString(swapMem), Double.toString(freeRamPerc), Double.toString(freeSwapPerc), loadave, loadave, loadave, String.valueOf(njobs));
        }
        return sga;
    }

    private long getInfoInMb(String string) {
        String measure;
        Pattern BYTE_INFO_PATTERN = Pattern.compile("(\\d+)(\\S+)");
        Matcher attrsMatcher = BYTE_INFO_PATTERN.matcher(string);
        attrsMatcher.find();
        long value = Long.parseLong(attrsMatcher.group(1));
        switch (measure = attrsMatcher.group(2)) {
            case "b": {
                value /= 1000000L;
                break;
            }
            case "kb": {
                value /= 1000L;
                break;
            }
            case "mb": {
                break;
            }
            case "gb": {
                value *= 1000L;
                break;
            }
            case "tb": {
                value *= 1000000L;
                break;
            }
            default: {
                value = 0L;
            }
        }
        return value;
    }

    private long getInfoInSec(String string) {
        Pattern BYTE_INFO_PATTERN = Pattern.compile("(\\d+):(\\d+):(\\d+)");
        Matcher attrsMatcher = BYTE_INFO_PATTERN.matcher(string);
        attrsMatcher.find();
        return Long.parseLong(attrsMatcher.group(1)) * 3600L + Long.parseLong(attrsMatcher.group(2)) * 60L + Long.parseLong(attrsMatcher.group(3));
    }
}

