/*
 * Decompiled with CFR 0.152.
 */
package csbase.sga.ssh;

import csbase.sshclient.SSHClient;
import csbase.sshclient.SSHClientException;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class SSHClientPool {
    private static long MAX_LEASE_TIME = 60000L;
    private List<SSHClient> activeClients = new Vector<SSHClient>();
    private List<SSHClient> availableClients = new Vector<SSHClient>();
    private Map<SSHClient, Long> clientReleaseTime = new Hashtable<SSHClient, Long>();
    private String sshHost;
    private int sshPort;
    private String sshUserName;
    private String sshUserPass;
    private String sshUserPrivKey;
    private boolean isTunnelEnable;
    private String sshTunnelHost;
    private int sshTunnelPort;
    private String sshTunnelUser;
    private String sshTunnelPass;
    private String sshTunnelPrivKey;
    private int sshTunnelLocalPort;
    private int sshTunnelLocalPortRange;

    public SSHClientPool(String sshHost, int sshPort, String sshUserName, String sshUserPass, String sshUserPrivKey, boolean isTunnelEnable, String sshTunnelHost, int sshTunnelPort, String sshTunnelUser, String sshTunnelPass, String sshTunnelPrivKey, int sshTunnelLocalPort, int sshTunnelLocalPortRange) {
        this.sshHost = sshHost;
        this.sshPort = sshPort;
        this.sshUserName = sshUserName;
        this.sshUserPass = sshUserPass;
        this.sshUserPrivKey = sshUserPrivKey;
        this.isTunnelEnable = isTunnelEnable;
        this.sshTunnelHost = sshTunnelHost;
        this.sshTunnelPort = sshTunnelPort;
        this.sshTunnelUser = sshTunnelUser;
        this.sshTunnelPass = sshTunnelPass;
        this.sshTunnelPrivKey = sshTunnelPrivKey;
        this.sshTunnelLocalPort = sshTunnelLocalPort;
        this.sshTunnelLocalPortRange = sshTunnelLocalPortRange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SSHClient retrieveSSHClient() throws SSHClientException {
        SSHClientPool sSHClientPool = this;
        synchronized (sSHClientPool) {
            if (!this.availableClients.isEmpty()) {
                SSHClient client = this.availableClients.remove(this.availableClients.size() - 1);
                this.activeClients.add(client);
                if (client.isConnected()) {
                    return client;
                }
            }
        }
        SSHClient client = new SSHClient(this.sshHost, this.sshPort);
        if (this.isTunnelEnable) {
            client.createTunnel(this.sshTunnelHost, this.sshTunnelPort, this.sshTunnelUser, this.sshTunnelPrivKey, this.sshTunnelLocalPort, this.sshTunnelLocalPortRange);
        }
        client.connect(this.sshUserName, this.sshUserPrivKey);
        SSHClientPool sSHClientPool2 = this;
        synchronized (sSHClientPool2) {
            this.activeClients.add(client);
        }
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void returnSSHClient(SSHClient sshClient) {
        SSHClientPool sSHClientPool = this;
        synchronized (sSHClientPool) {
            this.activeClients.remove(sshClient);
            this.availableClients.add(sshClient);
            this.clientReleaseTime.put(sshClient, System.currentTimeMillis());
            SSHClient leastUsedClient = this.availableClients.get(0);
            if (System.currentTimeMillis() - this.clientReleaseTime.get(leastUsedClient) > MAX_LEASE_TIME) {
                this.availableClients.remove(leastUsedClient);
                this.clientReleaseTime.remove(leastUsedClient);
                leastUsedClient.disconnect();
            }
        }
    }
}

