/*
 * Decompiled with CFR 0.152.
 */
package csbase.tools;

import csbase.logic.CommonProjectInfo;
import csbase.logic.ProjectPermissions;
import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;

public class ProjectInfoGenerator {
    public static void main(String[] args) {
        if (args.length < 3) {
            System.out.println("Bad arguments: projectname, userid, filename");
            System.exit(-1);
        }
        String projName = args[0];
        String userId = args[1];
        String fileName = args[2];
        ProjectInfoGenerator.generateFile(projName, userId, fileName);
    }

    public static void generateFile(String projName, String userId, String fileName) {
        CommonProjectInfo info = new CommonProjectInfo();
        info.name = projName;
        info.userId = userId;
        ProjectPermissions.setSharingType((CommonProjectInfo)info, (ProjectPermissions.SharingType)ProjectPermissions.SharingType.PRIVATE);
        try {
            File file = new File(fileName);
            FileOutputStream fout = new FileOutputStream(file);
            ObjectOutputStream out = new ObjectOutputStream(fout);
            out.writeObject(info);
            out.close();
        }
        catch (Exception e) {
            System.out.println("Exception detected!");
            e.printStackTrace();
            System.exit(-2);
        }
    }
}

