/*
 * Decompiled with CFR 0.152.
 */
package csbase.tools;

import csbase.tools.PropTab;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import tecgraf.javautils.core.lng.LNG;

public class PropEditor {
    private final Vector directories = new Vector();
    private final Properties metaProperties = new Properties();
    private final JFrame mainFrame = new JFrame();
    private final JTabbedPane tabbedPane = new JTabbedPane(2);

    private void startDialog() {
        JButton closeButton = new JButton();
        closeButton.setText(LNG.get((String)"PropEditor.visualization.close"));
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                System.exit(0);
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(new JPanel());
        buttonPanel.add(closeButton);
        buttonPanel.add(new JPanel());
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add((Component)new JPanel(), "East");
        mainPanel.add((Component)new JPanel(), "West");
        mainPanel.add((Component)buttonPanel, "South");
        mainPanel.add((Component)new JPanel(), "North");
        mainPanel.add((Component)this.tabbedPane, "Center");
        this.mainFrame.setContentPane(mainPanel);
        this.mainFrame.setTitle(LNG.get((String)"PropEditor.visualization.title"));
        this.mainFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        Dimension dim = new Dimension(700, 600);
        this.mainFrame.setSize(dim);
        this.mainFrame.setVisible(true);
    }

    private void loadFiles(File dir) {
        File[] files = dir.listFiles();
        int len = files.length;
        if (len <= 0) {
            System.out.println(LNG.get((String)"PropEditor.file.notfound"));
            return;
        }
        for (int i = 0; i < len; ++i) {
            File child = files[i];
            String name = child.getName();
            try {
                if (child.isDirectory()) continue;
                if (name.matches(".+\\.properties$")) {
                    PropTab pTab = new PropTab(this, child);
                    String title = name.replaceAll("\\.properties$", "");
                    this.tabbedPane.add(title, pTab.getPanel());
                    this.metaProperties.load(new FileInputStream(child));
                    continue;
                }
                if (!name.matches(".+\\.meta-properties$")) continue;
                this.metaProperties.load(new FileInputStream(child));
                continue;
            }
            catch (Exception e) {
                System.out.println(LNG.get((String)"PropEditor.file.error", (Object[])new String[]{e.getMessage(), name, e.getCause().toString()}));
                e.printStackTrace();
            }
        }
        PropEditor.onSpecialSyntax(this.metaProperties, false, true);
    }

    private void loadDirectory(String dirName) {
        System.out.println(LNG.get((String)"PropEditor.directory.check", (Object[])new String[]{dirName}));
        File dir = new File(dirName);
        if (!dir.isDirectory()) {
            System.out.println(LNG.get((String)"PropEditor.directory.notadir", (Object[])new String[]{dirName}));
            return;
        }
        this.loadFiles(dir);
    }

    private boolean searchForDirectories() {
        int n = this.directories.size();
        if (n <= 0) {
            return false;
        }
        System.out.println(LNG.get((String)"PropEditor.directory.check.multiple", (Object[])new String[]{Integer.toString(n)}));
        for (int i = 0; i < n; ++i) {
            String dir = (String)this.directories.get(i);
            if (dir != null) {
                this.loadDirectory(dir);
                continue;
            }
            System.out.println(LNG.get((String)"PropEditor.directory.load.error"));
        }
        return true;
    }

    private void parseArgs(String[] args) {
        for (String s : args) {
            if (s.startsWith("--directory")) {
                System.out.println(LNG.get((String)"PropEditor.directory.seek"));
                String[] split = s.split(":");
                if (split == null || split.length < 2) {
                    System.out.println(LNG.get((String)"PropEditor.directory.definition.error"));
                    continue;
                }
                String dir = split[1];
                if (dir != null) {
                    this.directories.add(dir);
                    continue;
                }
                System.out.println(LNG.get((String)"PropEditor.directory.seek.error"));
                continue;
            }
            System.out.println(LNG.get((String)"PropEditor.directory.parameter.error", (Object[])new String[]{s}));
        }
    }

    public String getEditorValue(String key) {
        String val = this.metaProperties.getProperty(key);
        if (val == null) {
            return "???                     {" + key + "}";
        }
        return val;
    }

    public static void onSpecialSyntax(Properties prop, boolean unloadSpecial, boolean unloadCommon) {
        Enumeration<?> e = prop.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (key.matches("^.*\\@.*\\@description$")) {
                if (!unloadSpecial) continue;
                prop.remove(key);
                continue;
            }
            if (!unloadCommon) continue;
            prop.remove(key);
        }
    }

    public PropEditor(String[] args) {
        this.parseArgs(args);
        if (!this.searchForDirectories()) {
            return;
        }
        this.startDialog();
    }

    public static void main(String[] args) {
        if (args == null || args.length <= 0) {
            System.out.println(LNG.get((String)"PropEditor.argument.notfound"));
            return;
        }
        PropEditor propEditor = new PropEditor(args);
    }
}

