package csbase.tools;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map.Entry;
import java.util.Map;
import java.util.Set;

import tecgraf.javautils.core.lng.LNG;

public class Dump {
  public static void main(String[] args) {
    if (args.length == 0) {
      System.err.println(LNG.get("Dump.usage"));
      System.exit(0);
    }
    for (int i=0; i<args.length; i++) {
      dump(args[i]);
    }
  }

  private static void dump(String fileName) {
    System.out.println("---------------------------");
    System.out.println(fileName);
    Object obj = null;
    try {
      ObjectInputStream in =
        new ObjectInputStream(
          new DataInputStream(
            new BufferedInputStream(new FileInputStream(fileName))));
      obj = in.readObject();
      in.close();
    }
    catch (Exception e) {
      System.out.println(LNG.get("Dump.error.read", new String[]{e.getMessage()}));
      return;
    }
    if (obj instanceof Collection) {
      dumpObject((Collection)obj);
    }
    else if (obj instanceof Map) {
      dumpObject("", (Map)obj);
    }
    else if (obj instanceof Object[]) {
      dumpObject((Object[])obj);
    }
    else {
      System.out.println(obj);
    }
  }

  private static void dumpObject(Collection c) {
    Iterator i = c.iterator();
    while (i.hasNext()) {
      System.out.print(i.next());
      if (i.hasNext()) {
        System.out.print(",");
      }
    }
    System.out.println("");
  }

  private static void dumpObject(String head, Map m) {
    Set s = m.entrySet();
    Iterator i = s.iterator();
    while (i.hasNext()) {
      Map.Entry e = (Map.Entry)i.next();
      Object k = e.getKey();
      Object v = e.getValue();
      if (v instanceof Collection) {
        System.out.print(head+k+" - ");
        dumpObject((Collection)v);
      }
      else if (v instanceof Object[]) {
        System.out.print(head+k+" - ");
        dumpObject((Object[])v);
      }
      else if (v instanceof Map) {
        System.out.println(head+k+" - <follows>");
        dumpObject("  "+head, (Map)v);
      }
      else {
        System.out.println(head+k+" - "+v);
      }
    }
  }

  private static void dumpObject(Object[] a) {
    for (int i=0; i<a.length; i++) {
      System.out.print(a[i]);
      if (i < a.length-1) {
        System.out.print(",");
      }
    }
    System.out.println("");
  }
}
