package csbase.util.data.dispatcher;


/**
 * Implementao abstrata de um {@link IDispatcher despachante} que retorna ao
 * {@link IDispatchListener ouvinte} o status da entrega dos dados.
 * 
 * @param <T> Tipo do destino.
 * @param <D> Tipo dos dados a serem despachados para o destino.
 *  
 * @author Tecgraf
 */
public abstract class AbstractDispatcher<T, D> implements IDispatcher<T, D> {

  /**
   * <p>
   * Repassa a obrigao de entregar os dados ao mtodo
   * {@link #dispatch(Object, Object...)} e retorna ao {@link IDispatchListener
   * ouvinte} o status da entrega dos dados.
   * </p>
   * {@inheritDoc}
   */
  @Override
  public void dispatch(IDispatchListener<T, D> callback, T destination,
    D... data) {
    try {
      dispatch(destination, data);
      callback.onDataDelivered(destination, data);
    }
    catch (Exception e) {
      callback.onExceptionThrown(e, destination, data);
    }
  }

  /**
   * Responsvel por entregar dados a seu destino.
   * 
   * @param destination Destino dos dados.
   * @param data Dados a serem entregues.
   * 
   * @throws Exception Indica que ocorreu um erro na entrega dos dados.
   */
  protected abstract void dispatch(T destination, D... data) throws Exception;
}
