package csbase.util.rmi;

/**
 * Implementao da interface {@link IPingable}
 *
 * @author Tecgraf
 */
public class Pingable implements IPingable {

  /**
   * {@inheritDoc}
   */
  @Override
  public void ping() {
    // No h necessidade de implementao.  utilizado como mtodo remoto dummy
    // para que um cliente possa verificar se a conexo com o servidor ainda
    // est vlida.
  }
  
  /**
   * {@inheritDoc}
   */
  @Override
  public boolean canReach(IPingable pingable) {
    try {
      pingable.ping();
      return true;
    }
    catch(Exception e) {
      return false;
    }
  }
}
