/*
 * Decompiled with CFR 0.152.
 */
package csbase.util.messages;

import csbase.util.messages.IMessageListener;
import csbase.util.messages.Message;
import csbase.util.messages.MessageStore;
import java.io.Serializable;
import java.util.ArrayList;

class AsynchronousConsumer
implements IMessageListener {
    private final Serializable consumerId;
    private final IMessageListener listener;
    private final MessageStore store;

    public AsynchronousConsumer(Serializable consumerId, IMessageListener listener, MessageStore store) {
        if (null == consumerId) {
            throw new NullPointerException("consumerId == null");
        }
        this.consumerId = consumerId;
        this.listener = listener;
        this.store = store;
    }

    public Serializable getId() {
        return this.consumerId;
    }

    @Override
    public void onMessagesReceived(Message ... messages) throws Exception {
        Message[] messages2send;
        ArrayList<MessageStore.Entry> entries2send = new ArrayList<MessageStore.Entry>();
        for (Message aMessage : messages) {
            MessageStore.Entry anEntry = this.store.getEntry(aMessage.getId());
            if (anEntry == null || !anEntry.setBeingSentTo(this.consumerId, true)) continue;
            entries2send.add(anEntry);
        }
        if (entries2send.size() == 0) {
            return;
        }
        if (entries2send.size() == messages.length) {
            messages2send = messages;
        } else {
            messages2send = new Message[entries2send.size()];
            for (int inx = 0; inx < entries2send.size(); ++inx) {
                messages2send[inx] = ((MessageStore.Entry)entries2send.get(inx)).getMessage();
            }
        }
        try {
            this.listener.onMessagesReceived(messages2send);
            for (MessageStore.Entry anEntry : entries2send) {
                anEntry.setAcknowledgedBy(this.consumerId);
            }
        }
        catch (Exception e) {
            for (MessageStore.Entry anEntry : entries2send) {
                anEntry.setBeingSentTo(this.consumerId, false);
            }
            throw e;
        }
    }

    public int hashCode() {
        return this.consumerId.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AsynchronousConsumer other = (AsynchronousConsumer)obj;
        return !(this.consumerId == null ? other.consumerId != null : !this.consumerId.equals(other.consumerId));
    }

    public String toString() {
        return this.consumerId.toString();
    }
}

