package csbase.util.rmi;

import java.rmi.Remote;
import java.rmi.RemoteException;

/**
 * Interface utilizada para checar a comunicao entre objetos de diferentes
 * servidores.
 */
public interface IPingable extends Remote {

  /**
   * Mtodo para verificar se a conexo com o servidor est ativa. Devem ser
   * checadas as excees <code>ConnectException</code> e
   * <code>NoSouchObjectException</code> para verificar se a conexo foi
   * perdida.
   * 
   * @throws RemoteException Caso haja problemas de comunicao com o servidor.
   */
  public void ping() throws RemoteException;

  /**
   * <p>
   * Verifica se este objeto consegue acessar outro objeto {@link IPingable}.
   * </p>
   * <p>
   * O cliente chama este mtodo, passando um {@link IPingable} exportado em uma
   * determinada porta, para testar se o servidor consegue acess-lo naquela
   * porta.
   * </p>
   * 
   * @param pingable Objeto a ser acessado.
   * @return <tt>True</tt> se a chamada ao mtodo {@link IPingable#ping()}
   *         retonou sem lanar exceo.
   * 
   * @throws RemoteException Caso haja problemas de comunicao com o servidor.
   */
  public boolean canReach(IPingable pingable) throws RemoteException;
}
