/*
 * Decompiled with CFR 0.152.
 */
package csbase.util.rmi;

import csbase.util.rmi.IPingable;
import csbase.util.rmi.Pingable;
import csbase.util.rmi.SocketFactory;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class PortReference {
    private static final Logger LOGGER = Logger.getLogger(PortReference.class.getName());
    private SocketFactory socketFactory = new SocketFactory();
    private Pingable pingable = new Pingable();
    private int port = -1;

    public boolean bind(int port) {
        if (this.port > 0) {
            this.unbind();
        }
        if (port < 0) {
            return false;
        }
        try {
            UnicastRemoteObject.exportObject(this.pingable, port, this.socketFactory, this.socketFactory);
            this.port = this.socketFactory.getLocalPort();
            return true;
        }
        catch (RemoteException e) {
            LogRecord record = new LogRecord(Level.WARNING, "Error binding with port " + this.port);
            record.setThrown(e);
            LOGGER.log(record);
            return false;
        }
    }

    public void unbind() {
        if (this.port > 0) {
            try {
                UnicastRemoteObject.unexportObject(this.pingable, true);
            }
            catch (RemoteException e) {
                LogRecord record = new LogRecord(Level.INFO, "Error unbinding port " + this.port);
                record.setThrown(e);
                LOGGER.log(record);
            }
            this.port = -1;
        }
    }

    public boolean isBound() {
        return this.port > 0;
    }

    public boolean isReachableBy(IPingable endpoint) {
        try {
            return endpoint.canReach(this.pingable);
        }
        catch (RemoteException e) {
            LogRecord record = new LogRecord(Level.WARNING, "Error unreachable by endpoint through port " + this.port);
            record.setThrown(e);
            LOGGER.log(record);
            return false;
        }
    }

    public Remote exportObject(Remote obj) throws RemoteException {
        if (this.port < 0) {
            throw new IllegalStateException("isBound() : false");
        }
        return UnicastRemoteObject.exportObject(obj, this.port, this.socketFactory, this.socketFactory);
    }

    public boolean unexportObject(Remote obj, boolean force) throws NoSuchObjectException {
        return UnicastRemoteObject.unexportObject(obj, force);
    }
}

