/*
 * Decompiled with CFR 0.152.
 */
package csbase.util.data.dispatcher;

import csbase.util.data.dispatcher.IDispatchListener;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import tecgraf.javautils.core.lng.LNG;

public class DispatchLogger<T, D>
implements IDispatchListener<T, D> {
    static final String className = DispatchLogger.class.getSimpleName();
    private final Logger LOGGER;
    private IDispatchListener<T, D> decorated;

    public DispatchLogger() {
        this(new IDispatchListener<T, D>(){

            @Override
            public void onDataDelivered(T destination, D ... data) {
            }

            @Override
            public void onExceptionThrown(Exception e, T destination, D ... data) {
            }
        });
    }

    public DispatchLogger(IDispatchListener<T, D> decorated) {
        this.decorated = decorated;
        this.LOGGER = Logger.getLogger(this.getClass().getName());
        this.LOGGER.setLevel(Level.ALL);
    }

    public void setLevel(Level level) {
        this.LOGGER.setLevel(Level.ALL);
    }

    @Override
    public void onExceptionThrown(Exception e, T destination, D ... data) {
        LogRecord record = new LogRecord(Level.WARNING, this.createExceptionThrown(destination, data));
        record.setThrown(e);
        this.LOGGER.log(record);
        this.decorated.onExceptionThrown(e, destination, data);
    }

    @Override
    public void onDataDelivered(T destination, D ... data) {
        this.LOGGER.log(Level.FINER, this.createDataDeliveredMessage(destination, data));
        this.decorated.onDataDelivered(destination, data);
    }

    protected String createExceptionThrown(T destination, D ... data) {
        return String.format(LNG.get((String)(className + ".deliverytodestination.inputerror"), (Object[])new Object[]{data.length, data[0].getClass().getName(), destination.getClass().getName()}), new Object[0]);
    }

    protected String createDataDeliveredMessage(T destination, D ... data) {
        return String.format(LNG.get((String)(className + ".deliverytodestination.success"), (Object[])new Object[]{data.length, data[0].getClass().getName(), destination.getClass().getName()}), new Object[0]);
    }
}

