/*
 * Decompiled with CFR 0.152.
 */
package csbase.util.restart;

import csbase.util.restart.RestartListener;
import java.util.LinkedList;
import java.util.List;
import tecgraf.javautils.core.lng.LNG;

public final class RestartManager {
    static final String className = RestartManager.class.getSimpleName();
    private static RestartManager instance;
    private final List<RestartListener> restartListenerList = new LinkedList<RestartListener>();

    public static RestartManager getInstance() {
        if (instance == null) {
            instance = new RestartManager();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(RestartListener restartListener) {
        List<RestartListener> list = this.restartListenerList;
        synchronized (list) {
            this.restartListenerList.add(restartListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart() {
        List<RestartListener> list = this.restartListenerList;
        synchronized (list) {
            for (RestartListener restartListener : this.restartListenerList) {
                try {
                    restartListener.restart();
                }
                catch (Exception e) {
                    String name = restartListener.getClass().getName();
                    String err = LNG.get((String)(className + ".error.restart.class"), (Object[])new String[]{name});
                    System.err.println(err);
                    e.printStackTrace();
                }
            }
        }
    }

    private RestartManager() {
    }
}

