package csbase.util.data.dispatcher;

/**
 * Ouvinte utilizado para observar uma entrega de dados.
 * 
 * @param <T> Tipo do destino.
 * @param <D> Tipo dos dados despachados.
 * 
 * @author Tecgraf
 */
public interface IDispatchListener<T, D> {
  /**
   * Mtodo utilizado para indicar que houve um erro durante a entrega dos dados
   * ao destino.
   * 
   * @param e Exceo lanada durante a entrega.
   * @param destination Destino dos dados.
   * @param data Dados Dados que deveriam ter sido entregues.
   */
  public void onExceptionThrown(Exception e, T destination, D... data);

  /**
   * Mtodo utilizado para indicar que os dados foram entregues com sucesso ao
   * destino.
   * 
   * @param destination Destino dos dados.
   * @param data Dados entregues.
   */
  public void onDataDelivered(T destination, D... data);
}
