/*
 * Decompiled with CFR 0.152.
 */
package validations.util;

import csbase.util.FileSystemUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Console;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ValidatorUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(File inputFile, File outputFile, Logger logger, boolean skipExisting) {
        if (!inputFile.exists()) {
            logger.severe(inputFile.getAbsolutePath() + " n\u00e3o existe");
            return false;
        }
        if (inputFile.isDirectory()) {
            logger.severe("arquivo de entrada " + inputFile.getAbsolutePath() + " \u00e9 um diret\u00f3rio");
            return false;
        }
        File outFile = outputFile.isDirectory() ? new File(outputFile.getAbsolutePath() + File.separatorChar + inputFile.getName()) : outputFile;
        if (outFile.exists()) {
            String path;
            try {
                path = outFile.getCanonicalPath();
            }
            catch (IOException e) {
                path = outFile.getAbsolutePath();
            }
            if (skipExisting) {
                logger.fine("Ignorando arquivo j\u00e1 existente " + path);
                return true;
            }
            logger.fine("Sobrescrevendo arquivo " + path);
        }
        try {
            outFile.createNewFile();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Erro criando arquivo arquivo de sa\u00edda" + outFile.getAbsolutePath(), e);
            return false;
        }
        BufferedInputStream in = null;
        FilterOutputStream out = null;
        try {
            in = new BufferedInputStream(new FileInputStream(inputFile));
            out = new BufferedOutputStream(new FileOutputStream(outFile));
            byte[] buffer = new byte[8192];
            int nread = in.read(buffer, 0, buffer.length);
            while (nread != -1) {
                ((BufferedOutputStream)out).write(buffer, 0, nread);
                nread = in.read(buffer, 0, buffer.length);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
                return false;
            }
        }
        return true;
    }

    public static boolean copyFiles(File[] files, File destination, Logger logger, boolean skipExisting) {
        if (!destination.isDirectory()) {
            throw new IllegalArgumentException(destination.getAbsolutePath() + " n\u00e3o \u00e9 um diret\u00f3rio");
        }
        for (File file : files) {
            if (ValidatorUtils.copyFile(file, destination, logger, skipExisting)) continue;
            return false;
        }
        return true;
    }

    public static boolean copyFile(String inputFile, String outputFile, Logger logger) {
        return ValidatorUtils.copyFile(new File(inputFile), new File(outputFile), logger, false);
    }

    public static boolean mkDir(String path) {
        File dir = new File(path);
        try {
            if (dir.exists()) {
                return dir.isDirectory();
            }
            return dir.mkdir();
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static boolean hasChildDir(File dir, String subDirName) {
        return FileSystemUtils.dirExists((File)dir) && FileSystemUtils.dirExists((String)(dir.getAbsolutePath() + File.separatorChar + subDirName));
    }

    public static boolean hasChildFile(File dir, String fileName) {
        File child = new File(dir, fileName);
        return FileSystemUtils.dirExists((File)dir) && child.exists() && child.isFile();
    }

    public static Map<String, File> getSubdirsMap(File dir) {
        HashMap<String, File> subDirsMap = new HashMap<String, File>();
        File[] subDirs = FileSystemUtils.getSubDirs((File)dir);
        if (subDirs == null || subDirs.length == 0) {
            return subDirsMap;
        }
        for (File subDir : subDirs) {
            String subDirName = subDir.getName();
            subDirsMap.put(subDirName, subDir);
        }
        return subDirsMap;
    }

    public static String readLine(Console console, String prompt) {
        if (console == null) {
            throw new IllegalArgumentException("console n\u00e3o pode ser null");
        }
        return console.readLine(prompt, new Object[0]).trim();
    }

    public static boolean readConfirmation(Console console, Option defaultOption) {
        String option = ValidatorUtils.readLine(console, String.format("  (s/n) [%s] ", defaultOption.value));
        if (option.isEmpty()) {
            return defaultOption == Option.YES;
        }
        return option.equals(Option.YES.value);
    }

    public static boolean copyDirectory(File srcDir, File dstDir) {
        return ValidatorUtils.copyDirectory(srcDir, dstDir, null);
    }

    public static boolean copyDirectory(File srcDir, File dstDir, Logger logger) {
        if (srcDir.isDirectory()) {
            if (!dstDir.exists() && !dstDir.mkdirs()) {
                String dstPath = dstDir.getAbsolutePath();
                logger.severe("Imposs\u00edvel criar novo diret\u00f3rio: " + dstPath);
                return false;
            }
            String[] files = srcDir.list();
            for (int i = 0; i < files.length; ++i) {
                File srcFile = new File(srcDir, files[i]);
                File dstFile = new File(dstDir, files[i]);
                boolean copied = ValidatorUtils.copyDirectory(srcFile, dstFile, logger);
                if (copied) continue;
                String dstPath = dstFile.getAbsolutePath();
                logger.severe("Falha na c\u00f3pia de item: " + dstPath);
                return false;
            }
        } else {
            if (!srcDir.exists()) {
                String srcPath = srcDir.getAbsolutePath();
                logger.severe("Arquivo ou dir. n\u00e3o encontrado: " + srcPath);
                return false;
            }
            boolean copied = ValidatorUtils.copyFile(srcDir, dstDir, logger, false);
            if (!copied) {
                String srcPath = srcDir.getAbsolutePath();
                String dstPath = dstDir.getAbsolutePath();
                String err = "Falha na c\u00f3pia de " + srcPath + " -> " + dstPath;
                logger.severe(err);
                return false;
            }
        }
        return true;
    }

    public static enum Option {
        YES("s"),
        NO("n");

        private final String value;

        private Option(String value) {
            this.value = value;
        }
    }
}

