/*
 * Decompiled with CFR 0.152.
 */
package validations;

import csbase.util.FileSystemUtils;
import java.io.File;
import java.text.MessageFormat;
import java.util.List;
import java.util.logging.Logger;
import tecgraf.javautils.core.lng.LNG;
import validations.AbstractValidation;
import validations.util.ValidatorUtils;

public final class PersistencyMoveValidation
extends AbstractValidation {
    private static final String BCK_USERDATA_SUBDIR_NAME = "usersdata";
    private static final String BCK_SHROBJS_SUBDIR_NAME = "shared-objects";
    private static final String BCK_PERS_SUBDIR_NAME = "persistent-data";
    private static final String NEW_PERS_DIR_PROP = "Persistency.newDirectory";
    private static final String OLD_PERS_DIR_PROP = "Persistency.oldDirectory";
    private static final String OLD_SHR_OBJ_DIR_PROP = "SharedObjects.oldDirectory";
    private static final String OLD_USR_DAT_DIR_PROP = "UsersData.oldDirectory";

    @Override
    protected boolean applyPatch() {
        File oldUsrDatDir = this.getFileProperty(OLD_USR_DAT_DIR_PROP);
        File oldShrObjDir = this.getFileProperty(OLD_SHR_OBJ_DIR_PROP);
        File newUsrDatDir = this.getNewUsersDataDir();
        File newShrObjDir = this.getNewSharedObjectsDir();
        File newPersDir = this.getFileProperty(NEW_PERS_DIR_PROP);
        if (FileSystemUtils.dirExists((File)newPersDir)) {
            String path = newPersDir.getAbsolutePath();
            this.logger.severe(LNG.get((String)"validations.ExistentNewDir") + path);
            return false;
        }
        if (!newPersDir.mkdirs()) {
            String path = newPersDir.getAbsolutePath();
            this.logger.severe(LNG.get((String)"validations.DirCreationFail") + path);
            return false;
        }
        if (!this.move(oldUsrDatDir, newUsrDatDir)) {
            return false;
        }
        if (!this.move(oldShrObjDir, newShrObjDir)) {
            return false;
        }
        File oldPersDir = this.getFileProperty(OLD_PERS_DIR_PROP);
        File[] children = oldPersDir.listFiles();
        String sep = File.separator;
        if (children != null && children.length > 0) {
            for (File child : children) {
                String fileName = child.getName();
                String newPath = newPersDir.getAbsolutePath() + sep + fileName;
                File newFile = new File(newPath);
                String fmt = LNG.get((String)"validations.MoveElement");
                String msg = String.format(fmt, newFile.getName());
                this.logger.fine(msg);
                if (child.renameTo(newFile)) continue;
                String path = newPersDir.getAbsolutePath();
                this.logger.severe(LNG.get((String)"validations.InternalMoveFail") + path);
                return false;
            }
        }
        FileSystemUtils.deleteRecursively((File)oldPersDir, (Logger)this.logger);
        return true;
    }

    @Override
    protected void finish() {
    }

    private File getFileProperty(String propName) {
        String dirPath = this.getMandatorySystemProperty(propName);
        if (dirPath == null) {
            return null;
        }
        File dir = new File(dirPath);
        return dir;
    }

    private File getNewSharedObjectsDir() {
        File newPersDir = this.getFileProperty(NEW_PERS_DIR_PROP);
        String subDirName = BCK_SHROBJS_SUBDIR_NAME;
        String newUsrDatDirPath = newPersDir + File.separator + BCK_SHROBJS_SUBDIR_NAME;
        return new File(newUsrDatDirPath);
    }

    private File getNewUsersDataDir() {
        File newPersDir = this.getFileProperty(NEW_PERS_DIR_PROP);
        String subDirName = "sga-groups";
        String newUsrDatDirPath = newPersDir + File.separator + "sga-groups";
        return new File(newUsrDatDirPath);
    }

    @Override
    protected void getSpecificFailureMessage(AbstractValidation.Status status, List<String> errors) {
        switch (status) {
            case VALIDATION_FAILED: {
                errors.add(LNG.get((String)"validations.OldPersistStructure"));
                break;
            }
            case PATCH_FAILED: {
                errors.add(LNG.get((String)"validations.ErrorPersistConversion"));
                break;
            }
            case INIT_FAILED: {
                errors.add(LNG.get((String)"validations.ErrorAtStart"));
                break;
            }
            default: {
                errors.add(LNG.get((String)"validations.InvalidState") + status.toString());
            }
        }
    }

    @Override
    protected String getStartMessage() {
        return LNG.get((String)"validations.ConvertingServerPersistence");
    }

    @Override
    protected String getSuccessMessage(AbstractValidation.Status status) {
        switch (status) {
            case VALIDATION_OK: {
                return LNG.get((String)"validations.ReStructurePersistenceDone");
            }
            case PATCH_OK: {
                return LNG.get((String)"validations.ReStructurePersistenceSuccessful");
            }
        }
        return LNG.get((String)"validations.InvalidState") + status.toString();
    }

    @Override
    protected boolean init() {
        String oPath;
        File oldPersDir = this.getFileProperty(OLD_PERS_DIR_PROP);
        File newPersDir = this.getFileProperty(NEW_PERS_DIR_PROP);
        File oldShrObjDir = this.getFileProperty(OLD_SHR_OBJ_DIR_PROP);
        File oldUsrDatDir = this.getFileProperty(OLD_USR_DAT_DIR_PROP);
        if (oldShrObjDir == null || newPersDir == null || oldUsrDatDir == null || oldPersDir == null) {
            return false;
        }
        String nPath = newPersDir.getAbsolutePath();
        if (nPath.equals(oPath = oldPersDir.getAbsolutePath())) {
            String msg = LNG.get((String)"validations.SameOldAndNewPersistDir");
            this.logger.severe(msg);
            return false;
        }
        return true;
    }

    private boolean move(File srcDir, File dstDir) {
        String srcPath = srcDir.getAbsolutePath();
        String destPath = dstDir.getAbsolutePath();
        if (!srcDir.renameTo(dstDir)) {
            this.logger.severe(MessageFormat.format(LNG.get((String)"validations.MovingPersistDirFail"), srcPath, destPath));
            return false;
        }
        this.logger.fine(MessageFormat.format(LNG.get((String)"validations.MovingFromTo"), srcPath, destPath));
        return true;
    }

    @Override
    protected boolean backupData() {
        String bckPath = this.getBackupDirPath();
        String sep = File.separator;
        File oldUsrDatDir = this.getFileProperty(OLD_USR_DAT_DIR_PROP);
        String bckUsrDatPath = bckPath + sep + BCK_USERDATA_SUBDIR_NAME;
        File bckUsrDatDir = new File(bckUsrDatPath);
        FileSystemUtils.deleteRecursively((File)bckUsrDatDir, (Logger)this.logger);
        ValidatorUtils.copyDirectory(oldUsrDatDir, bckUsrDatDir, this.logger);
        File oldShrObjDir = this.getFileProperty(OLD_SHR_OBJ_DIR_PROP);
        String bckShrObjPath = bckPath + sep + BCK_SHROBJS_SUBDIR_NAME;
        File bckShrObjDir = new File(bckShrObjPath);
        FileSystemUtils.deleteRecursively((File)bckShrObjDir, (Logger)this.logger);
        ValidatorUtils.copyDirectory(oldShrObjDir, bckShrObjDir, this.logger);
        File oldPersDir = this.getFileProperty(OLD_PERS_DIR_PROP);
        String bckPersPath = bckPath + sep + BCK_PERS_SUBDIR_NAME;
        File bckPersDir = new File(bckPersPath);
        FileSystemUtils.deleteRecursively((File)bckPersDir, (Logger)this.logger);
        ValidatorUtils.copyDirectory(oldPersDir, bckPersDir, this.logger);
        return true;
    }

    @Override
    protected boolean restoreBackup() {
        String bckPath = this.getBackupDirPath();
        String sep = File.separator;
        File newPersDir = this.getFileProperty(NEW_PERS_DIR_PROP);
        FileSystemUtils.deleteRecursively((File)newPersDir, (Logger)this.logger);
        File oldUsrDatDir = this.getFileProperty(OLD_USR_DAT_DIR_PROP);
        String bckUsrDatPath = bckPath + sep + BCK_USERDATA_SUBDIR_NAME;
        File bckUsrDatDir = new File(bckUsrDatPath);
        FileSystemUtils.deleteRecursively((File)oldUsrDatDir, (Logger)this.logger);
        ValidatorUtils.copyDirectory(bckUsrDatDir, oldUsrDatDir, this.logger);
        File oldShrObjDir = this.getFileProperty(OLD_SHR_OBJ_DIR_PROP);
        String bckShrObjPath = bckPath + sep + BCK_SHROBJS_SUBDIR_NAME;
        File bckShrObjDir = new File(bckShrObjPath);
        FileSystemUtils.deleteRecursively((File)oldShrObjDir, (Logger)this.logger);
        ValidatorUtils.copyDirectory(bckShrObjDir, oldShrObjDir, this.logger);
        File oldPersDir = this.getFileProperty(OLD_PERS_DIR_PROP);
        String bckPersPath = bckPath + sep + BCK_PERS_SUBDIR_NAME;
        File bckPersDir = new File(bckPersPath);
        FileSystemUtils.deleteRecursively((File)oldPersDir, (Logger)this.logger);
        ValidatorUtils.copyDirectory(bckPersDir, oldPersDir, this.logger);
        return true;
    }

    @Override
    protected boolean validate() {
        File newPersDir = this.getFileProperty(NEW_PERS_DIR_PROP);
        File newUsrDatDir = this.getNewUsersDataDir();
        File newShrObjDir = this.getNewSharedObjectsDir();
        if (FileSystemUtils.dirExists((File)newPersDir) && FileSystemUtils.dirExists((File)newUsrDatDir) && FileSystemUtils.dirExists((File)newShrObjDir)) {
            this.logger.info(LNG.get((String)"validations.NewPersistDirExists"));
            return true;
        }
        File oldPersDir = this.getFileProperty(OLD_PERS_DIR_PROP);
        File oldShrObjDir = this.getFileProperty(OLD_SHR_OBJ_DIR_PROP);
        File oldUsrDatDir = this.getFileProperty(OLD_USR_DAT_DIR_PROP);
        if (!(FileSystemUtils.dirExists((File)oldPersDir) || FileSystemUtils.dirExists((File)oldUsrDatDir) || FileSystemUtils.dirExists((File)oldShrObjDir))) {
            this.logger.info(LNG.get((String)"validations.OldPersistDirNotExists"));
            return true;
        }
        return false;
    }

    @Override
    protected boolean runsOnlyOnce() {
        return true;
    }
}

