/*
 * Decompiled with CFR 0.152.
 */
package validations;

import csbase.util.FileSystemUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import tecgraf.javautils.core.io.FileUtils;
import validations.AbstractValidation;
import validations.util.ValidatorUtils;

public class WallTimePropertyValidation
extends AbstractValidation {
    private static final String COMMANDS_DIRECTORY = ".cmds";
    private static final String COMMANDS_PROPERTIES = "cmd.properties";
    private static final String WALL_TIME_PROPERTY = "wallTimeSec";
    private final ValidateWallTimeProperty VALIDATE_WALL_TIME_PROPERTY = new ValidateWallTimeProperty();
    private final FixWallTimeProperty FIX_WALL_TIME_PROPERTY = new FixWallTimeProperty();
    private final BackupProperties BACKUP_PROPERTIES = new BackupProperties();
    private final RestoreProperties RESTORE_PROPERTIES = new RestoreProperties();
    private File projectDir;

    @Override
    protected boolean init() {
        this.projectDir = this.getProjectDir();
        return this.projectDir != null;
    }

    @Override
    protected boolean validate() {
        return this.visitCommandsDirs(this.projectDir, this.VALIDATE_WALL_TIME_PROPERTY);
    }

    @Override
    protected boolean backupData() {
        return this.visitCommandsDirs(this.projectDir, this.BACKUP_PROPERTIES);
    }

    @Override
    protected boolean restoreBackup() {
        File backupDir = new File(this.getBackupDirPath());
        if (this.visitCommandsDirs(backupDir, this.RESTORE_PROPERTIES)) {
            FileUtils.delete((File)backupDir);
            return true;
        }
        return false;
    }

    @Override
    protected boolean applyPatch() {
        return this.visitCommandsDirs(this.projectDir, this.FIX_WALL_TIME_PROPERTY);
    }

    @Override
    protected void finish() {
    }

    @Override
    protected String getStartMessage() {
        return "Corrigindo propriedade 'wallTimeSec' com valor negativo nos comandos.";
    }

    @Override
    protected String getSuccessMessage(AbstractValidation.Status status) {
        switch (status) {
            case VALIDATION_OK: {
                return "*** TODOS OS COMANDOS TEM UM VALOR V\u00c1LIDO PARA A PROPRIEDADE 'wallTimeSec'.";
            }
            case PATCH_OK: {
                return "*** A PROPRIEDADE 'wallTimeSec' FOI CORRIGIDA EM TODOS OS COMANDOS.";
            }
        }
        return "ESTADO INV\u00c1LIDO: " + status.toString();
    }

    @Override
    protected void getSpecificFailureMessage(AbstractValidation.Status status, List<String> errors) {
        switch (status) {
            case VALIDATION_FAILED: {
                errors.add("*** EXISTEM COMANDOS COM VALOR INV\u00c1LIDO NA PROPRIEDADE 'wallTimeSec'.");
                break;
            }
            case PATCH_FAILED: {
                errors.add("*** OCORRE UM ERRO AO TENTAR CORRIGIR A PROPRIEDADE 'wallTimeSec' DE UM OU MAIS COMANDOS.");
                break;
            }
            case INIT_FAILED: {
                errors.add("*** FALHA NA INICIALIZA\u00c7\u00c3O");
                break;
            }
            default: {
                errors.add("ESTADO INV\u00c1LIDO: " + status.toString());
            }
        }
    }

    private boolean visitCommandsDirs(File prjDir, FileVisitor visitor) {
        File[] users = FileSystemUtils.getSubDirs((File)prjDir);
        if (users == null || users.length == 0) {
            String path = prjDir.getAbsolutePath();
            this.logger.fine("N\u00e3o h\u00e1 diret\u00f3rios de usu\u00e1rios em: " + path);
            return true;
        }
        for (File aUser : users) {
            File[] aProjects = FileSystemUtils.getSubDirs((File)aUser);
            if (aProjects == null || aProjects.length == 0) {
                String path = aUser.getAbsolutePath();
                this.logger.fine("N\u00e3o h\u00e1 diret\u00f3rios de projetos em: " + path);
                return true;
            }
            for (File aProject : aProjects) {
                File cmds = new File(aProject, COMMANDS_DIRECTORY);
                if (!cmds.exists()) continue;
                File[] aCmds = FileSystemUtils.getSubDirs((File)cmds);
                if (aCmds == null || aCmds.length == 0) {
                    String path = aUser.getAbsolutePath();
                    this.logger.fine("N\u00e3o h\u00e1 diret\u00f3rios de comandos em: " + path);
                    return true;
                }
                for (File aCmd : aCmds) {
                    File propertiesFile = new File(aCmd, COMMANDS_PROPERTIES);
                    if (visitor.visit(propertiesFile)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    protected boolean runsOnlyOnce() {
        return true;
    }

    static interface FileVisitor {
        public boolean visit(File var1);
    }

    class ValidateWallTimeProperty
    implements FileVisitor {
        ValidateWallTimeProperty() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public boolean visit(File propertiesFile) {
            block17: {
                block18: {
                    FileInputStream inStream;
                    block16: {
                        if (!propertiesFile.exists()) break block18;
                        inStream = null;
                        inStream = new FileInputStream(propertiesFile);
                        Properties properties = new Properties();
                        properties.load(inStream);
                        if (!properties.containsKey(WallTimePropertyValidation.WALL_TIME_PROPERTY)) break block16;
                        int wallTime = Integer.valueOf(properties.getProperty(WallTimePropertyValidation.WALL_TIME_PROPERTY).trim());
                        boolean bl = wallTime >= 0;
                        try {
                            if (inStream != null) {
                                inStream.close();
                            }
                        }
                        catch (IOException e) {
                            WallTimePropertyValidation.this.logger.exception(String.format("Erro fechando stream para o arquivo '%s'", propertiesFile.getAbsolutePath()), e);
                        }
                        return bl;
                    }
                    try {
                        if (inStream != null) {
                            inStream.close();
                        }
                        break block17;
                    }
                    catch (IOException e) {
                        WallTimePropertyValidation.this.logger.exception(String.format("Erro fechando stream para o arquivo '%s'", propertiesFile.getAbsolutePath()), e);
                    }
                    break block17;
                    catch (Exception e) {
                        try {
                            WallTimePropertyValidation.this.logger.exception("Exce\u00e7\u00e3o tentando ler o arquivo '" + propertiesFile.getAbsolutePath() + "'", e);
                        }
                        catch (Throwable throwable) {
                            try {
                                if (inStream != null) {
                                    inStream.close();
                                }
                            }
                            catch (IOException e2) {
                                WallTimePropertyValidation.this.logger.exception(String.format("Erro fechando stream para o arquivo '%s'", propertiesFile.getAbsolutePath()), e2);
                            }
                            throw throwable;
                        }
                        try {
                            if (inStream != null) {
                                inStream.close();
                            }
                            break block17;
                        }
                        catch (IOException e3) {
                            WallTimePropertyValidation.this.logger.exception(String.format("Erro fechando stream para o arquivo '%s'", propertiesFile.getAbsolutePath()), e3);
                        }
                        break block17;
                    }
                }
                WallTimePropertyValidation.this.logger.warning("Arquivo '" + propertiesFile.getAbsolutePath() + "' n\u00e3o encontrado");
            }
            return true;
        }
    }

    class BackupProperties
    implements FileVisitor {
        BackupProperties() {
        }

        @Override
        public boolean visit(File properties) {
            File cmd = properties.getParentFile();
            File commands = cmd.getParentFile();
            File project = commands.getParentFile();
            File user = project.getParentFile();
            String bkpCmdPath = user.getName() + File.separatorChar + project.getName() + File.separatorChar + commands.getName() + File.separator + cmd.getName();
            File bkpCmd = new File(WallTimePropertyValidation.this.getBackupDirPath(), bkpCmdPath);
            if (!bkpCmd.exists() && !bkpCmd.mkdirs()) {
                WallTimePropertyValidation.this.logger.severe("Erro criando diret\u00f3rio de backup '" + bkpCmd.getAbsolutePath() + "'");
                return false;
            }
            File bkpProperties = new File(bkpCmd, properties.getName());
            if (!ValidatorUtils.copyFile(properties, bkpProperties, WallTimePropertyValidation.this.logger, true)) {
                WallTimePropertyValidation.this.logger.severe(String.format("erro fazendo backup do arquivo '%s' do usu\u00e1rio %s", properties.getAbsolutePath(), user.getName()));
                return false;
            }
            return true;
        }
    }

    class RestoreProperties
    implements FileVisitor {
        RestoreProperties() {
        }

        @Override
        public boolean visit(File bkpProperties) {
            File bkpCmd = bkpProperties.getParentFile();
            File bkpCommands = bkpCmd.getParentFile();
            File bkpProject = bkpCommands.getParentFile();
            File bkpUser = bkpProject.getParentFile();
            String cmdPath = bkpUser.getName() + File.separatorChar + bkpProject.getName() + File.separatorChar + bkpCommands.getName() + File.separator + bkpCmd.getName();
            File cmd = new File(WallTimePropertyValidation.this.projectDir, cmdPath);
            if (!cmd.exists()) {
                WallTimePropertyValidation.this.logger.severe("Diret\u00f3rio do comando '" + cmd.getAbsolutePath() + "' n\u00e3o existe");
                return false;
            }
            File properties = new File(cmd, bkpProperties.getName());
            if (!ValidatorUtils.copyFile(bkpProperties, properties, WallTimePropertyValidation.this.logger, false)) {
                WallTimePropertyValidation.this.logger.severe(String.format("Erro restaurando arquivo '%s' do usu\u00e1rio %s", bkpProperties.getAbsolutePath(), bkpUser.getName()));
                return false;
            }
            FileUtils.delete((File)bkpCmd);
            return true;
        }
    }

    class FixWallTimeProperty
    implements FileVisitor {
        FixWallTimeProperty() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public boolean visit(File properties) {
            block25: {
                block26: {
                    String line;
                    if (!properties.exists()) break block26;
                    File cmd = properties.getParentFile();
                    File commands = cmd.getParentFile();
                    File project = commands.getParentFile();
                    File user = project.getParentFile();
                    String bkpPropertiesPath = user.getName() + File.separatorChar + project.getName() + File.separatorChar + commands.getName() + File.separator + cmd.getName() + File.separator + properties.getName();
                    File bkpProperties = new File(WallTimePropertyValidation.this.getBackupDirPath(), bkpPropertiesPath);
                    BufferedReader reader = null;
                    BufferedWriter writer = null;
                    properties.delete();
                    reader = new BufferedReader(new FileReader(bkpProperties));
                    writer = new BufferedWriter(new FileWriter(properties));
                    while ((line = reader.readLine()) != null) {
                        if (line.matches("\\s*wallTimeSec\\s*[=\\s]\\s*-\\d+\\s*")) {
                            writer.write("# wallTimeSec = ");
                        } else {
                            writer.write(line);
                        }
                        writer.newLine();
                    }
                    writer.flush();
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                    }
                    catch (IOException e) {
                        WallTimePropertyValidation.this.logger.exception(String.format("Erro fechando stream para o arquivo '%s'", properties.getAbsolutePath()), e);
                    }
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                        break block25;
                    }
                    catch (IOException e) {
                        WallTimePropertyValidation.this.logger.exception(String.format("Erro fechando stream para o arquivo '%s'", bkpProperties.getAbsolutePath()), e);
                    }
                    break block25;
                    catch (Exception e) {
                        boolean bl;
                        try {
                            WallTimePropertyValidation.this.logger.exception("Erro tentando ler o arquivo '" + bkpProperties.getAbsolutePath() + "' e escrever no arquivo '" + properties.getAbsolutePath() + "'", e);
                            bl = false;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (writer != null) {
                                    writer.close();
                                }
                            }
                            catch (IOException e2) {
                                WallTimePropertyValidation.this.logger.exception(String.format("Erro fechando stream para o arquivo '%s'", properties.getAbsolutePath()), e2);
                            }
                            try {
                                if (reader != null) {
                                    reader.close();
                                }
                            }
                            catch (IOException e3) {
                                WallTimePropertyValidation.this.logger.exception(String.format("Erro fechando stream para o arquivo '%s'", bkpProperties.getAbsolutePath()), e3);
                            }
                            throw throwable;
                        }
                        try {
                            if (writer != null) {
                                writer.close();
                            }
                        }
                        catch (IOException e4) {
                            WallTimePropertyValidation.this.logger.exception(String.format("Erro fechando stream para o arquivo '%s'", properties.getAbsolutePath()), e4);
                        }
                        try {
                            if (reader != null) {
                                reader.close();
                            }
                        }
                        catch (IOException e5) {
                            WallTimePropertyValidation.this.logger.exception(String.format("Erro fechando stream para o arquivo '%s'", bkpProperties.getAbsolutePath()), e5);
                        }
                        return bl;
                    }
                }
                WallTimePropertyValidation.this.logger.warning("Arquivo '" + properties.getAbsolutePath() + "' n\u00e3o encontrado");
            }
            return true;
        }
    }
}

