/** \file
 * \brief Bindig of iupfilechooser to Lua 3.
 *
 * See Copyright Notice in iup.h
 * $Id: luafilechooser.c 75808 2008-05-08 21:03:37Z clinio $
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <iup.h>
#include "iupfilechooser.h"
#include <lua.h>
#include <lualib.h>
#include <iuplua.h>
#include "luafilechooser.h"

static int iuplua_tag = 0;

static void CreateFileChooser(void) {
  Ihandle *h = IupFileChooser();
  lua_pushusertag(h, iuplua_tag);
}

int filechooserlua_open(void) {
  iuplua_tag = (int)lua_getnumber(lua_getglobal("iuplua_tag"));
  lua_register("IupCreateFileChooser", CreateFileChooser);

#ifdef LUA
  return iuplua_dofile("luafilechooser.lua");
#else
#ifdef TEC_BIGENDIAN
#ifdef TEC_64
#include "luafilechooser_be64.loh"  // big endian (motorola/network) on 64-bits
#else
#include "luafilechooser_be32.loh"  // big endian (motorola/network) on 32-bits
#endif  
#else
#ifdef TEC_64
#ifdef WIN64
#include "luafilechooser_le64w.loh"  // little endian (intel) on 64-bits (Win)
#else
#include "luafilechooser_le64.loh"  // little endian (intel) on 64-bits
#endif  
#else
#include "luafilechooser.loh"    // little endian (intel) on 32-bits
#endif  
#endif  
  return 1;
#endif

}
