package Requests.Authentication;

import Requests.User.User;

import java.util.Objects;

public class Token   {
	private String accessToken = null;
	private String tokenType = null;
	private User user = null;

	public Token accessToken(String accessToken) {
		this.accessToken = accessToken;
		return this;
	}

	public String getAccessToken() {
		return accessToken;
	}

	public void setAccessToken(String accessToken) {
		this.accessToken = accessToken;
	}

	public Token tokenType(String tokenType) {
		this.tokenType = tokenType;
		return this;
	}

	public String getTokenType() {
		return tokenType;
	}

	public void setTokenType(String tokenType) {
		this.tokenType = tokenType;
	}

	public Token user(User user) {
		this.user = user;
		return this;
	}
	public User getUser() {
		return user;
	}

	public void setUser(User user) {
		this.user = user;
	}


	@Override
	public boolean equals(java.lang.Object o) {
		if (this == o) {
			return true;
		}
		if (o == null || getClass() != o.getClass()) {
			return false;
		}
		Token token = (Token) o;
		return Objects.equals(this.accessToken, token.accessToken) &&
				Objects.equals(this.tokenType, token.tokenType) &&
				Objects.equals(this.user, token.user);
	}

	@Override
	public int hashCode() {
		return Objects.hash(accessToken, tokenType, user);
	}

	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();
		sb.append("class Token {\n");

		sb.append("    accessToken: ").append(toIndentedString(accessToken)).append("\n");
		sb.append("    tokenType: ").append(toIndentedString(tokenType)).append("\n");
		sb.append("    user: ").append(toIndentedString(user)).append("\n");
		sb.append("}");
		return sb.toString();
	}

	private String toIndentedString(java.lang.Object o) {
		if (o == null) {
			return "null";
		}
		return o.toString().replace("\n", "\n    ");
	}
}

