/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.poa.gui.beans;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;

public class FillLevelCanvas
extends Canvas {
    private Graphics buf = null;
    private Image img = null;
    private Color color1 = Color.orange;
    private Color color2 = Color.red;
    private int width = 0;
    private int height = 0;
    private int max = 0;
    private int avg = 0;
    private int min = 0;
    private int cur = 0;
    private int yAvg = 0;
    private int yCur = 0;
    private boolean useAvg;

    public FillLevelCanvas() {
        this.initialize();
    }

    public int getYAvg() {
        if (this.useAvg) {
            return this.yAvg;
        }
        return 0;
    }

    private void handleException(Throwable exception) {
    }

    public void init(int _min, int _avg, int _max, Color _color1, Color _color2, boolean _useAvg) {
        this.min = _min;
        this.avg = _avg;
        this.max = _max;
        this.useAvg = _useAvg;
        this.yCompute();
        if (_color1 != null) {
            this.color1 = _color1;
        }
        if (_color2 != null) {
            this.color2 = _color2;
        }
    }

    private void initialize() {
        this.setName("FillLevelCanvas");
        this.setBackground(Color.white);
        this.setSize(15, 100);
        this.width = this.getBounds().width;
        this.height = this.getBounds().height;
    }

    public static void main(String[] args) {
        try {
            Frame frame;
            try {
                Class<?> aFrameClass = Class.forName("com.ibm.uvm.abt.edit.TestFrame");
                frame = (Frame)aFrameClass.newInstance();
            }
            catch (Throwable ivjExc) {
                frame = new Frame();
            }
            FillLevelCanvas aFillLevelCanvas = new FillLevelCanvas();
            frame.add("Center", aFillLevelCanvas);
            frame.setSize(aFillLevelCanvas.getSize());
            frame.setVisible(true);
        }
        catch (Throwable exception) {
            System.err.println("Exception occurred in main() of org.jacorb.poa.gui.FillLevelCanvas");
            exception.printStackTrace(System.out);
        }
    }

    @Override
    public void paint(Graphics g) {
        if (this.buf == null) {
            this.img = this.createImage(this.getBounds().width, this.getBounds().height);
            this.buf = this.img.getGraphics();
        } else {
            this.buf.setColor(this.getBackground());
            this.buf.fillRect(0, 0, this.width, this.height);
            this.buf.setColor(this.getForeground());
        }
        this.paintUnbuffered(this.buf);
        g.drawImage(this.img, 0, 0, this);
    }

    public void paintUnbuffered(Graphics g) {
        if (this.useAvg) {
            if (this.cur <= this.avg) {
                g.setColor(this.color1);
                g.fillRect(0, this.yCur, this.width, this.height - this.yCur);
            } else {
                g.setColor(this.color2);
                g.fillRect(0, this.yCur, this.width, this.height - this.yCur);
                g.setColor(this.color1);
                g.fillRect(0, this.yAvg, this.width, this.height - this.yAvg);
            }
            if (this.avg < this.max) {
                g.setColor(Color.black);
                g.drawLine(0, this.yAvg, this.width, this.yAvg);
            }
        } else {
            g.setColor(this.color1);
            g.fillRect(0, this.yCur, this.width, this.height - this.yCur);
        }
    }

    public void setAvg(int value) {
        this.avg = value;
        this.yCompute();
        this.repaint();
    }

    public void setCurrent(int value) {
        this.cur = value;
        this.yCompute();
        this.repaint();
    }

    public void setMax(int value) {
        this.max = value;
        this.yCompute();
        this.repaint();
    }

    public void setMin(int value) {
        this.min = value;
        this.yCompute();
        this.repaint();
    }

    private void yCompute() {
        float helpF;
        if (this.useAvg) {
            helpF = (float)this.avg / ((float)this.max - (float)this.min) * (float)this.height;
            this.yAvg = this.yTransform((int)helpF);
        }
        helpF = (float)this.cur / ((float)this.max - (float)this.min) * (float)this.height;
        this.yCur = this.yTransform((int)helpF);
    }

    private int yTransform(int y) {
        return this.height - y;
    }
}

